/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.accessor;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.CompiledInvoker;
import org.drools.core.rule.accessor.Invoker;
import org.kie.internal.security.KiePolicyHelper;

public interface Accumulator
extends Invoker {
    public Object createWorkingMemoryContext();

    public Object createContext();

    public Object init(Object var1, Object var2, Tuple var3, Declaration[] var4, ReteEvaluator var5);

    public Object accumulate(Object var1, Object var2, Tuple var3, InternalFactHandle var4, Declaration[] var5, Declaration[] var6, ReteEvaluator var7);

    public boolean supportsReverse();

    public boolean tryReverse(Object var1, Object var2, Tuple var3, InternalFactHandle var4, Object var5, Declaration[] var6, Declaration[] var7, ReteEvaluator var8);

    public Object getResult(Object var1, Object var2, Tuple var3, Declaration[] var4, ReteEvaluator var5);

    default public void replaceDeclaration(Declaration declaration, Declaration resolved) {
    }

    default public Declaration[] getRequiredDeclarations() {
        return new Declaration[0];
    }

    public static class SafeAccumulator
    implements Accumulator,
    Serializable {
        private static final long serialVersionUID = -2845820209337318924L;
        private Accumulator delegate;

        public SafeAccumulator(Accumulator delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object createWorkingMemoryContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return delegate.createWorkingMemoryContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Object createContext() {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return delegate.createContext();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public Object init(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final Declaration[] declarations, final ReteEvaluator reteEvaluator) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return delegate.init(workingMemoryContext, context, leftTuple, declarations, reteEvaluator);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object accumulate(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final InternalFactHandle handle, final Declaration[] declarations, final Declaration[] innerDeclarations, final ReteEvaluator reteEvaluator) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return delegate.accumulate(workingMemoryContext, context, leftTuple, handle, declarations, innerDeclarations, reteEvaluator);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
            throw new IllegalStateException("Should not reach here, as it should return from the prior 'run'");
        }

        @Override
        public boolean supportsReverse() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return delegate.supportsReverse();
                }
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean tryReverse(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final InternalFactHandle handle, final Object value, final Declaration[] declarations, final Declaration[] innerDeclarations, final ReteEvaluator reteEvaluator) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        return delegate.tryReverse(workingMemoryContext, context, leftTuple, handle, value, declarations, innerDeclarations, reteEvaluator);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object getResult(final Object workingMemoryContext, final Object context, final Tuple leftTuple, final Declaration[] declarations, final ReteEvaluator reteEvaluator) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return delegate.getResult(workingMemoryContext, context, leftTuple, declarations, reteEvaluator);
                    }
                }, KiePolicyHelper.getAccessContext());
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

