/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.assertj.core.api.Assertions;
import org.drools.io.ReaderResource;
import org.junit.Test;

public class ReaderResourceTest {
    static final Charset[] availableCharsets = Charset.availableCharsets().values().toArray(new Charset[0]);

    @Test
    public void defaultEncodingInitialization() throws UnsupportedEncodingException {
        String anyEncoding = availableCharsets[0].name();
        ByteArrayInputStream istream = new ByteArrayInputStream(new byte[0]);
        InputStreamReader ireader = new InputStreamReader((InputStream)istream, anyEncoding);
        ReaderResource iresource = new ReaderResource((Reader)ireader, null, null);
        Assertions.assertThat((String)iresource.getEncoding()).isEqualTo(ireader.getEncoding());
        String differentEncoding = availableCharsets[1].name();
        ireader = new InputStreamReader((InputStream)istream, differentEncoding);
        iresource = new ReaderResource((Reader)ireader, null, null);
        Assertions.assertThat((String)iresource.getEncoding()).isEqualTo(ireader.getEncoding());
    }

    @Test
    public void overwritingEncodingInitialization() throws UnsupportedEncodingException {
        String anyEncoding = availableCharsets[0].name();
        ByteArrayInputStream istream = new ByteArrayInputStream(new byte[0]);
        InputStreamReader ireader = new InputStreamReader((InputStream)istream, anyEncoding);
        String overwrittenEncoding = availableCharsets[1].name();
        ReaderResource iresource = new ReaderResource((Reader)ireader, overwrittenEncoding, null);
        Assertions.assertThat((String)iresource.getEncoding()).isEqualTo(overwrittenEncoding);
        Assertions.assertThat((String)iresource.getEncoding()).isNotEqualTo((Object)ireader.getEncoding());
    }
}

