/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.Random;
import org.assertj.core.api.Assertions;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.TupleRBTree;
import org.junit.Test;

public class LeftTupleRBTreeTest {
    @Test
    public void testIterator() {
        int i;
        int ITEMS = 10000;
        TupleRBTree tree = new TupleRBTree();
        Random random = new Random(0L);
        for (i = 0; i < 10000; ++i) {
            int key = random.nextInt();
            tree.insert((Comparable)Integer.valueOf(key));
        }
        i = 0;
        FastIterator fastIterator = tree.fastIterator();
        int lastKey = Integer.MIN_VALUE;
        TupleRBTree.Node node = (TupleRBTree.Node)fastIterator.next(null);
        while (node != null) {
            int currentKey = (Integer)node.key;
            if (currentKey < lastKey) {
                Assertions.fail((String)(currentKey + " should be greater than " + lastKey));
            }
            lastKey = currentKey;
            ++i;
            node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        }
        Assertions.assertThat((int)i).isEqualTo(10000);
    }

    @Test
    public void testRange() {
        TupleRBTree tree = new TupleRBTree();
        tree.insert((Comparable)Integer.valueOf(10));
        tree.insert((Comparable)Integer.valueOf(20));
        tree.insert((Comparable)Integer.valueOf(25));
        tree.insert((Comparable)Integer.valueOf(15));
        tree.insert((Comparable)Integer.valueOf(5));
        FastIterator fastIterator = tree.range((Comparable)Integer.valueOf(2), true, (Comparable)Integer.valueOf(15), false);
        TupleRBTree.Node node = (TupleRBTree.Node)fastIterator.next(null);
        Assertions.assertThat((int)((Integer)node.key)).isEqualTo(5);
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assertions.assertThat((int)((Integer)node.key)).isEqualTo(10);
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assertions.assertThat((Comparable)node).isNull();
        fastIterator = tree.range((Comparable)Integer.valueOf(2), true, (Comparable)Integer.valueOf(5), false);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assertions.assertThat((Comparable)node).isNull();
        fastIterator = tree.range((Comparable)Integer.valueOf(25), false, (Comparable)Integer.valueOf(35), true);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assertions.assertThat((Comparable)node).isNull();
        fastIterator = tree.range((Comparable)Integer.valueOf(6), false, (Comparable)Integer.valueOf(9), false);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assertions.assertThat((Comparable)node).isNull();
        fastIterator = tree.range((Comparable)Integer.valueOf(5), false, (Comparable)Integer.valueOf(35), false);
        node = (TupleRBTree.Node)fastIterator.next(null);
        Assertions.assertThat((int)((Integer)node.key)).isEqualTo(10);
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assertions.assertThat((int)((Integer)node.key)).isEqualTo(15);
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assertions.assertThat((int)((Integer)node.key)).isEqualTo(20);
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assertions.assertThat((int)((Integer)node.key)).isEqualTo(25);
        node = (TupleRBTree.Node)fastIterator.next((Entry)node);
        Assertions.assertThat((Comparable)node).isNull();
    }
}

