/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.core.SessionConfiguration;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.JDKTimerServiceTest;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.junit.Test;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;

public class CronJobTest {
    @Test
    public void testCronTriggerJob() throws Exception {
        SessionConfiguration config = new SessionConfiguration();
        config.setOption((KieSessionOption)ClockTypeOption.PSEUDO);
        PseudoClockScheduler timeService = (PseudoClockScheduler)TimerServiceFactory.getTimerService((SessionConfiguration)config);
        timeService.advanceTime(0L, TimeUnit.MILLISECONDS);
        CronTrigger trigger = new CronTrigger(0L, null, null, -1, "15 * * * * ?", null, null);
        JDKTimerServiceTest.HelloWorldJobContext ctx = new JDKTimerServiceTest.HelloWorldJobContext("hello world", (TimerService)timeService);
        timeService.scheduleJob((Job)new JDKTimerServiceTest.HelloWorldJob(), (JobContext)ctx, (Trigger)trigger);
        Assertions.assertThat((List)ctx.getList()).hasSize(0);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(0);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(1);
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(1);
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(2);
    }
}

