/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.NaturalComparator;
import org.drools.core.util.Queue;
import org.junit.Test;

public class BinaryHeapPriorityQueueTest {
    @Test
    public void testOptimised() {
        Random random = new Random();
        ArrayList<LongQueueable> items = new ArrayList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE);
        for (int i = 0; i < 100000; ++i) {
            items.add(new LongQueueable(queue, random.nextLong()));
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            queue.enqueue((Queue.QueueEntry)i.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            ((Queue.QueueEntry)i2.next()).dequeue();
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }

    @Test
    public void testBasic() {
        Random random = new Random();
        ArrayList<LongQueueable> items = new ArrayList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE);
        for (int i = 0; i < 100000; ++i) {
            items.add(new LongQueueable(queue, random.nextLong()));
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            queue.enqueue((Queue.QueueEntry)i.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            queue.enqueue((Queue.QueueEntry)i2.next());
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }

    public class LongQueueable
    implements Queue.QueueEntry,
    Comparable {
        private final Long value;
        private BinaryHeapQueue queue;

        public LongQueueable(BinaryHeapQueue queue, long value) {
            this.queue = queue;
            this.value = value;
        }

        public void dequeue() {
            this.queue.dequeue();
        }

        public boolean isQueued() {
            return false;
        }

        public void setQueued(boolean activated) {
        }

        public int compareTo(Object object) {
            return this.value.compareTo(((LongQueueable)object).value);
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

