/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.assertj.core.api.Assertions;
import org.drools.core.base.ValueType;
import org.drools.core.base.extractors.BaseObjectClassFieldReader;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.accessor.TupleValueExtractor;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;
import org.drools.core.util.index.FastUtilTreeMemory;
import org.drools.core.util.index.IndexUtil;
import org.junit.Test;

public class FastUtilTreeMemoryTest {
    @Test
    public void testMocks() {
        TupleValueExtractor leftValueExtractor = FastUtilTreeMemoryTest.getTupleValueExtractor();
        ReadAccessor rightValueExtractor = FastUtilTreeMemoryTest.getRightExtractor();
        Tuple tuple10 = FastUtilTreeMemoryTest.getLeftTuple(10);
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(rightValueExtractor, leftValueExtractor);
        Assertions.assertThat((Object)fieldIndex.getLeftExtractor().getValue(tuple10)).isEqualTo((Object)10);
    }

    @Test
    public void testGreaterThan() {
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(FastUtilTreeMemoryTest.getRightExtractor(), FastUtilTreeMemoryTest.getTupleValueExtractor());
        FastUtilTreeMemory treeMemory = new FastUtilTreeMemory(IndexUtil.ConstraintType.GREATER_THAN, fieldIndex, false);
        Tuple tuple10 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple20 = FastUtilTreeMemoryTest.getLeftTuple(20);
        Tuple tuple30 = FastUtilTreeMemoryTest.getLeftTuple(30);
        Tuple tuple40 = FastUtilTreeMemoryTest.getLeftTuple(40);
        treeMemory.add(tuple10);
        treeMemory.add(tuple20);
        treeMemory.add(tuple30);
        treeMemory.add(tuple40);
        FastUtilTreeMemory.TreeFastIterator it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatEquals(it, 10, 20);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatIsNull(it, 50);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        Tuple tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 5, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
    }

    @Test
    public void testGreaterOrEqual() {
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(FastUtilTreeMemoryTest.getRightExtractor(), FastUtilTreeMemoryTest.getTupleValueExtractor());
        FastUtilTreeMemory treeMemory = new FastUtilTreeMemory(IndexUtil.ConstraintType.GREATER_OR_EQUAL, fieldIndex, false);
        Tuple tuple10 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple20 = FastUtilTreeMemoryTest.getLeftTuple(20);
        Tuple tuple30 = FastUtilTreeMemoryTest.getLeftTuple(30);
        Tuple tuple40 = FastUtilTreeMemoryTest.getLeftTuple(40);
        treeMemory.add(tuple10);
        treeMemory.add(tuple20);
        treeMemory.add(tuple30);
        treeMemory.add(tuple40);
        FastUtilTreeMemory.TreeFastIterator it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatEquals(it, 10, 10);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatIsNull(it, 50);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        Tuple tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 5, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
    }

    @Test
    public void testLessOrEqual() {
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(FastUtilTreeMemoryTest.getRightExtractor(), FastUtilTreeMemoryTest.getTupleValueExtractor());
        FastUtilTreeMemory treeMemory = new FastUtilTreeMemory(IndexUtil.ConstraintType.LESS_OR_EQUAL, fieldIndex, false);
        Tuple tuple10 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple20 = FastUtilTreeMemoryTest.getLeftTuple(20);
        Tuple tuple30 = FastUtilTreeMemoryTest.getLeftTuple(30);
        Tuple tuple40 = FastUtilTreeMemoryTest.getLeftTuple(40);
        treeMemory.add(tuple10);
        treeMemory.add(tuple20);
        treeMemory.add(tuple30);
        treeMemory.add(tuple40);
        FastUtilTreeMemory.TreeFastIterator it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatIsNull(it, 5);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        Tuple tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 10, 10);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 20, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 30, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 35, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 45, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
    }

    @Test
    public void testLessThan() {
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(FastUtilTreeMemoryTest.getRightExtractor(), FastUtilTreeMemoryTest.getTupleValueExtractor());
        FastUtilTreeMemory treeMemory = new FastUtilTreeMemory(IndexUtil.ConstraintType.LESS_THAN, fieldIndex, false);
        Tuple tuple10 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple20 = FastUtilTreeMemoryTest.getLeftTuple(20);
        Tuple tuple30 = FastUtilTreeMemoryTest.getLeftTuple(30);
        Tuple tuple40 = FastUtilTreeMemoryTest.getLeftTuple(40);
        treeMemory.add(tuple10);
        treeMemory.add(tuple20);
        treeMemory.add(tuple30);
        treeMemory.add(tuple40);
        FastUtilTreeMemory.TreeFastIterator it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatIsNull(it, 5);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        FastUtilTreeMemoryTest.assertThatIsNull(it, 10);
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        Tuple tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 20, 10);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 30, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 35, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 45, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
    }

    @Test
    public void testSharedFirstBucket() {
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(FastUtilTreeMemoryTest.getRightExtractor(), FastUtilTreeMemoryTest.getTupleValueExtractor());
        FastUtilTreeMemory treeMemory = new FastUtilTreeMemory(IndexUtil.ConstraintType.GREATER_THAN, fieldIndex, false);
        Tuple tuple10_1 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple10_2 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple10_3 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple20 = FastUtilTreeMemoryTest.getLeftTuple(20);
        Tuple tuple30 = FastUtilTreeMemoryTest.getLeftTuple(30);
        Tuple tuple40 = FastUtilTreeMemoryTest.getLeftTuple(40);
        treeMemory.add(tuple10_1);
        treeMemory.add(tuple10_2);
        treeMemory.add(tuple10_3);
        treeMemory.add(tuple20);
        treeMemory.add(tuple30);
        treeMemory.add(tuple40);
        FastUtilTreeMemory.TreeFastIterator it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        Tuple tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 5, 10);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple10_1);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 10);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple10_2);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 10);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple10_3);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        FastIterator fullit = treeMemory.fullFastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(fullit, 10);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple10_1);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 10);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple10_2);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 10);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple10_3);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 40);
        Assertions.assertThat((Object)fullit.next((Object)tuple)).isNull();
    }

    @Test
    public void testSharedLastBucket() {
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex(FastUtilTreeMemoryTest.getRightExtractor(), FastUtilTreeMemoryTest.getTupleValueExtractor());
        FastUtilTreeMemory treeMemory = new FastUtilTreeMemory(IndexUtil.ConstraintType.GREATER_THAN, fieldIndex, false);
        Tuple tuple10 = FastUtilTreeMemoryTest.getLeftTuple(10);
        Tuple tuple20 = FastUtilTreeMemoryTest.getLeftTuple(20);
        Tuple tuple30 = FastUtilTreeMemoryTest.getLeftTuple(30);
        Tuple tuple40_1 = FastUtilTreeMemoryTest.getLeftTuple(40);
        Tuple tuple40_2 = FastUtilTreeMemoryTest.getLeftTuple(40);
        Tuple tuple40_3 = FastUtilTreeMemoryTest.getLeftTuple(40);
        treeMemory.add(tuple10);
        treeMemory.add(tuple20);
        treeMemory.add(tuple30);
        treeMemory.add(tuple40_1);
        treeMemory.add(tuple40_2);
        treeMemory.add(tuple40_3);
        FastUtilTreeMemory.TreeFastIterator it = (FastUtilTreeMemory.TreeFastIterator)treeMemory.fastIterator();
        Tuple tuple = FastUtilTreeMemoryTest.assertThatEquals(it, 5, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple40_1);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple40_2);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, it, 40);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple40_3);
        Assertions.assertThat((Object)it.next(tuple)).isNull();
        FastIterator fullit = treeMemory.fullFastIterator();
        tuple = FastUtilTreeMemoryTest.assertThatEquals(fullit, 10);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 20);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 30);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 40);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple40_1);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 40);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple40_2);
        tuple = FastUtilTreeMemoryTest.assertThatEquals(tuple, fullit, 40);
        Assertions.assertThat((Object)tuple).isSameAs((Object)tuple40_3);
        Assertions.assertThat((Object)fullit.next((Object)tuple)).isNull();
    }

    private static Tuple assertThatEquals(Tuple tuple, FastUtilTreeMemory.TreeFastIterator it, int expected) {
        tuple = it.next(tuple);
        return FastUtilTreeMemoryTest.assertThatEquals(tuple, expected);
    }

    private static Tuple assertThatEquals(Tuple tuple, FastIterator it, int expected) {
        tuple = (Tuple)it.next((Object)tuple);
        return FastUtilTreeMemoryTest.assertThatEquals(tuple, expected);
    }

    private static Tuple assertThatEquals(FastUtilTreeMemory.TreeFastIterator it, int first, int expected) {
        Tuple tuple = it.getFirst(FastUtilTreeMemoryTest.getLeftTuple(first));
        return FastUtilTreeMemoryTest.assertThatEquals(tuple, expected);
    }

    private static Tuple assertThatEquals(FastIterator it, int expected) {
        Tuple tuple = (Tuple)it.next(null);
        return FastUtilTreeMemoryTest.assertThatEquals(tuple, expected);
    }

    private static void assertThatIsNull(FastUtilTreeMemory.TreeFastIterator it, int first) {
        Tuple tuple = it.getFirst(FastUtilTreeMemoryTest.getLeftTuple(first));
        Assertions.assertThat((Object)tuple).isNull();
    }

    private static Tuple assertThatEquals(Tuple tuple, int expected) {
        Assertions.assertThat((Object)tuple.getFactHandle().getObject()).isEqualTo((Object)expected);
        return tuple;
    }

    public static InternalFactHandle getFactHandle(int number) {
        return new DefaultFactHandle((Object)number);
    }

    public static Tuple getLeftTuple(int number) {
        JoinNodeLeftTuple tuple = new JoinNodeLeftTuple();
        tuple.setFactHandle(FastUtilTreeMemoryTest.getFactHandle(number));
        return tuple;
    }

    public static TupleValueExtractor getTupleValueExtractor() {
        TupleValueExtractor extractor = new TupleValueExtractor(){

            public ValueType getValueType() {
                return null;
            }

            public Object getValue(ReteEvaluator reteEvaluator, Tuple tuple) {
                return tuple.getFactHandle().getObject();
            }

            public TupleValueExtractor clone() {
                return null;
            }
        };
        return extractor;
    }

    public static ReadAccessor getRightExtractor() {
        BaseObjectClassFieldReader readAccessor = new BaseObjectClassFieldReader(){

            public Object getValue(ReteEvaluator reteEvaluator, Object object) {
                return object;
            }
        };
        return readAccessor;
    }
}

