/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.assertj.core.api.Assertions;
import org.drools.core.util.ScalablePool;
import org.junit.Test;

public class ScalablePoolTest {
    @Test
    public void testPoolOf1() {
        Monitor monitor = new Monitor();
        this.check(monitor, 0, 0, 0);
        ScalablePool pool = new ScalablePool(1, () -> new PooledResource(monitor), PooledResource::reset, PooledResource::dispose);
        this.check(monitor, 1, 0, 0);
        PooledResource resource = (PooledResource)pool.get();
        this.check(monitor, 1, 0, 0);
        pool.release((Object)resource);
        this.check(monitor, 1, 1, 0);
        PooledResource resource2 = (PooledResource)pool.get();
        Assertions.assertThat((Object)resource).isSameAs((Object)resource2);
        this.check(monitor, 1, 1, 0);
        pool.shutdown();
        this.check(monitor, 1, 1, 1);
    }

    @Test
    public void testPool() {
        Monitor monitor = new Monitor();
        this.check(monitor, 0, 0, 0);
        ScalablePool pool = new ScalablePool(3, () -> new PooledResource(monitor), PooledResource::reset, PooledResource::dispose);
        this.check(monitor, 3, 0, 0);
        PooledResource resource1 = (PooledResource)pool.get();
        PooledResource resource2 = (PooledResource)pool.get();
        PooledResource resource3 = (PooledResource)pool.get();
        this.check(monitor, 3, 0, 0);
        pool.release((Object)resource3);
        this.check(monitor, 3, 1, 0);
        resource3 = (PooledResource)pool.get();
        this.check(monitor, 3, 1, 0);
        PooledResource resource4 = (PooledResource)pool.get();
        this.check(monitor, 4, 1, 0);
        PooledResource resource5 = (PooledResource)pool.get();
        this.check(monitor, 5, 1, 0);
        pool.release((Object)resource4);
        this.check(monitor, 5, 2, 0);
        resource4 = (PooledResource)pool.get();
        this.check(monitor, 5, 2, 0);
        pool.shutdown();
        this.check(monitor, 5, 2, 5);
    }

    private void check(Monitor monitor, int expectedNew, int expectedReset, int expectedDispose) {
        Assertions.assertThat((int)monitor.newCounter).isEqualTo(expectedNew);
        Assertions.assertThat((int)monitor.resetCounter).isEqualTo(expectedReset);
        Assertions.assertThat((int)monitor.disposeCounter).isEqualTo(expectedDispose);
    }

    public static class PooledResource {
        private final Monitor monitor;

        public PooledResource(Monitor monitor) {
            this.monitor = monitor;
            ++monitor.newCounter;
        }

        public void reset() {
            ++this.monitor.resetCounter;
        }

        public void dispose() {
            ++this.monitor.disposeCounter;
        }
    }

    public static class Monitor {
        private int newCounter;
        private int resetCounter;
        private int disposeCounter;
    }
}

