/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.Comparator;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.Queue;
import org.drools.core.util.TreeSetQueue;
import org.drools.util.Config;

public class QueueFactory {
    private static final String BINARY_HEAP_QUEUE = "binaryheap";
    private static final String TREE_SET_QUEUE = "treeset";
    private static final String DEFAULT_QUEUE = "treeset";
    private static final QueueType QUEUE_TYPE = QueueType.get(Config.getConfig((String)"org.drools.queuetype", (String)"treeset"));

    public static <T extends Queue.QueueEntry> Queue<T> createQueue(Comparator<T> comparator) {
        return QueueFactoryHolder.INSTANCE.createQueue(comparator);
    }

    static class TreeSetQueueFactory
    implements Factory {
        TreeSetQueueFactory() {
        }

        @Override
        public <T extends Queue.QueueEntry> Queue<T> createQueue(Comparator<T> comparator) {
            return new TreeSetQueue<T>(comparator);
        }
    }

    static class BinaryHeapQueueFactory
    implements Factory {
        BinaryHeapQueueFactory() {
        }

        @Override
        public <T extends Queue.QueueEntry> Queue<T> createQueue(Comparator<T> comparator) {
            return new BinaryHeapQueue<T>(comparator);
        }
    }

    static class QueueFactoryHolder {
        private static final Factory INSTANCE = QUEUE_TYPE.createFactory();

        QueueFactoryHolder() {
        }
    }

    static interface Factory {
        public <T extends Queue.QueueEntry> Queue<T> createQueue(Comparator<T> var1);
    }

    public static enum QueueType {
        BINARY_HEAP,
        TREE_SET;


        static QueueType get(String s) {
            if (s.equalsIgnoreCase("treeset")) {
                return TREE_SET;
            }
            if (s.equalsIgnoreCase(QueueFactory.BINARY_HEAP_QUEUE)) {
                return BINARY_HEAP;
            }
            throw new UnsupportedOperationException("Unknown queue type: " + s);
        }

        Factory createFactory() {
            return this == TREE_SET ? new TreeSetQueueFactory() : new BinaryHeapQueueFactory();
        }
    }
}

