/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.util.ArrayList;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.constraint.BetaNodeFieldConstraint;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexUtil;
import org.kie.internal.conf.IndexPrecedenceOption;

public class IndexSpec {
    private IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.UNKNOWN;
    private AbstractHashTable.FieldIndex[] indexes;

    IndexSpec(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        this.init(nodeType, constraints, config);
    }

    public IndexUtil.ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public AbstractHashTable.FieldIndex[] getIndexes() {
        return this.indexes;
    }

    public AbstractHashTable.FieldIndex getIndex(int pos) {
        return this.indexes[pos];
    }

    private void init(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        int firstIndexableConstraint;
        int keyDepth = config.getCompositeKeyDepth();
        IndexPrecedenceOption indexPrecedenceOption = config.getIndexPrecedenceOption();
        int n = firstIndexableConstraint = indexPrecedenceOption == IndexPrecedenceOption.EQUALITY_PRIORITY ? this.determineTypeWithEqualityPriority(nodeType, constraints, config) : this.determineTypeWithPatternOrder(nodeType, constraints, config);
        if (this.constraintType == IndexUtil.ConstraintType.EQUAL) {
            ArrayList<AbstractHashTable.FieldIndex> indexList = new ArrayList<AbstractHashTable.FieldIndex>();
            indexList.add(((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex());
            for (int i = firstIndexableConstraint + 1; i < constraints.length && indexList.size() < keyDepth; ++i) {
                if (IndexUtil.ConstraintType.getType(constraints[i]) != IndexUtil.ConstraintType.EQUAL || ((IndexableConstraint)((Object)constraints[i])).isUnification()) continue;
                indexList.add(((IndexableConstraint)((Object)constraints[i])).getFieldIndex());
            }
            this.indexes = indexList.toArray(new AbstractHashTable.FieldIndex[indexList.size()]);
        } else if (this.constraintType.isComparison()) {
            this.indexes = new AbstractHashTable.FieldIndex[]{((IndexableConstraint)((Object)constraints[firstIndexableConstraint])).getFieldIndex()};
        }
    }

    private int determineTypeWithEqualityPriority(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        int indexedConstraintPos = 0;
        for (int i = 0; i < constraints.length; ++i) {
            if (!(constraints[i] instanceof IndexableConstraint)) continue;
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)constraints[i]);
            IndexUtil.ConstraintType type = indexableConstraint.getConstraintType();
            if (type == IndexUtil.ConstraintType.EQUAL) {
                this.constraintType = type;
                return i;
            }
            if (this.constraintType != IndexUtil.ConstraintType.UNKNOWN || !type.isIndexableForNode(nodeType, indexableConstraint, config)) continue;
            this.constraintType = type;
            indexedConstraintPos = i;
        }
        return indexedConstraintPos;
    }

    private int determineTypeWithPatternOrder(short nodeType, BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration config) {
        for (int i = 0; i < constraints.length; ++i) {
            IndexUtil.ConstraintType type = IndexUtil.ConstraintType.getType(constraints[i]);
            if (!type.isIndexableForNode(nodeType, (IndexableConstraint)((Object)constraints[i]), config)) continue;
            this.constraintType = type;
            return i;
        }
        return constraints.length;
    }
}

