/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ContextEntry;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.TupleValueExtractor;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.util.FieldIndex;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.base.util.index.IndexUtil;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexFactory;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.conf.CompositeConfiguration;
import org.kie.internal.conf.ConfigurationFactory;
import org.kie.internal.conf.IndexPrecedenceOption;
import org.kie.internal.utils.ChainedProperties;

public class IndexUtilTest {
    @Test
    public void isEqualIndexable() {
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.PINTEGER_TYPE));
        Assertions.assertThat((boolean)IndexUtil.isEqualIndexable((BetaNodeFieldConstraint)intEqualsConstraint)).isTrue();
        FakeBetaNodeFieldConstraint intLessThanConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.LESS_THAN, new FakeReadAccessor(ValueType.PINTEGER_TYPE));
        Assertions.assertThat((boolean)IndexUtil.isEqualIndexable((BetaNodeFieldConstraint)intLessThanConstraint)).isFalse();
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)IndexUtil.isEqualIndexable((BetaNodeFieldConstraint)bigDecimalEqualsConstraint)).as("BigDecimal equality cannot be indexed because of scale", new Object[0])).isFalse();
    }

    @Test
    public void createBetaMemoryWithIntEquals_shouldBeTupleIndexHashTable() {
        RuleBaseConfiguration config = this.getRuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.PINTEGER_TYPE));
        BetaMemory betaMemory = IndexFactory.createBetaMemory((RuleBaseConfiguration)config, (short)181, (BetaNodeFieldConstraint[])new BetaNodeFieldConstraint[]{intEqualsConstraint});
        Assertions.assertThat((Object)betaMemory.getLeftTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
        Assertions.assertThat((Object)betaMemory.getRightTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
    }

    private RuleBaseConfiguration getRuleBaseConfiguration() {
        return new RuleBaseConfiguration(new CompositeConfiguration(ChainedProperties.getChainedProperties(null), null, new ConfigurationFactory[0]));
    }

    @Test
    public void createBetaMemoryWithBigDecimalEquals_shouldNotBeTupleIndexHashTable() {
        RuleBaseConfiguration config = this.getRuleBaseConfiguration();
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        BetaMemory betaMemory = IndexFactory.createBetaMemory((RuleBaseConfiguration)config, (short)181, (BetaNodeFieldConstraint[])new BetaNodeFieldConstraint[]{bigDecimalEqualsConstraint});
        Assertions.assertThat((Object)betaMemory.getLeftTupleMemory()).isInstanceOf(TupleList.class);
        Assertions.assertThat((Object)betaMemory.getRightTupleMemory()).isInstanceOf(TupleList.class);
    }

    @Test
    public void createBetaMemoryWithBigDecimalEqualsAndOtherIndexableConstraints_shouldBeTupleIndexHashTableButBigDecimalIsNotIndexed() {
        RuleBaseConfiguration config = this.getRuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.PINTEGER_TYPE));
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        FakeBetaNodeFieldConstraint stringEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.STRING_TYPE));
        BetaMemory betaMemory = IndexFactory.createBetaMemory((RuleBaseConfiguration)config, (short)181, (BetaNodeFieldConstraint[])new BetaNodeFieldConstraint[]{intEqualsConstraint, bigDecimalEqualsConstraint, stringEqualsConstraint});
        Assertions.assertThat((Object)betaMemory.getLeftTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
        AbstractHashTable.Index leftIndex = ((TupleIndexHashTable)betaMemory.getLeftTupleMemory()).getIndex();
        Assertions.assertThat((Object)leftIndex).isInstanceOf(AbstractHashTable.DoubleCompositeIndex.class);
        FieldIndex leftFieldIndex0 = leftIndex.getFieldIndex(0);
        Assertions.assertThat((Comparable)leftFieldIndex0.getLeftExtractor().getValueType()).isEqualTo((Object)ValueType.PINTEGER_TYPE);
        FieldIndex leftFieldIndex1 = leftIndex.getFieldIndex(1);
        Assertions.assertThat((Comparable)leftFieldIndex1.getLeftExtractor().getValueType()).isEqualTo((Object)ValueType.STRING_TYPE);
        Assertions.assertThat((Object)betaMemory.getRightTupleMemory()).isInstanceOf(TupleIndexHashTable.class);
        AbstractHashTable.Index rightIndex = ((TupleIndexHashTable)betaMemory.getRightTupleMemory()).getIndex();
        Assertions.assertThat((Object)rightIndex).isInstanceOf(AbstractHashTable.DoubleCompositeIndex.class);
        FieldIndex rightFieldIndex0 = rightIndex.getFieldIndex(0);
        Assertions.assertThat((Comparable)rightFieldIndex0.getRightExtractor().getValueType()).isEqualTo((Object)ValueType.PINTEGER_TYPE);
        FieldIndex rightFieldIndex1 = rightIndex.getFieldIndex(1);
        Assertions.assertThat((Comparable)rightFieldIndex1.getRightExtractor().getValueType()).isEqualTo((Object)ValueType.STRING_TYPE);
    }

    @Test
    public void isIndexableForNodeWithIntAndString() {
        RuleBaseConfiguration config = this.getRuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.PINTEGER_TYPE));
        FakeBetaNodeFieldConstraint stringEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.STRING_TYPE));
        BetaNodeFieldConstraint[] constraints = new FakeBetaNodeFieldConstraint[]{intEqualsConstraint, stringEqualsConstraint};
        boolean[] indexed = IndexUtil.isIndexableForNode((IndexPrecedenceOption)IndexPrecedenceOption.EQUALITY_PRIORITY, (short)181, (int)config.getCompositeKeyDepth(), (BetaNodeFieldConstraint[])constraints, (KieBaseConfiguration)config);
        Assertions.assertThat((boolean[])indexed).containsExactly(new boolean[]{true, true});
    }

    @Test
    public void isIndexableForNodeWithIntAndBigDecimalAndString() {
        RuleBaseConfiguration config = this.getRuleBaseConfiguration();
        FakeBetaNodeFieldConstraint intEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.PINTEGER_TYPE));
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        FakeBetaNodeFieldConstraint stringEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.STRING_TYPE));
        BetaNodeFieldConstraint[] constraints = new FakeBetaNodeFieldConstraint[]{intEqualsConstraint, bigDecimalEqualsConstraint, stringEqualsConstraint};
        boolean[] indexed = IndexUtil.isIndexableForNode((IndexPrecedenceOption)IndexPrecedenceOption.EQUALITY_PRIORITY, (short)181, (int)config.getCompositeKeyDepth(), (BetaNodeFieldConstraint[])constraints, (KieBaseConfiguration)config);
        ((AbstractBooleanArrayAssert)Assertions.assertThat((boolean[])indexed).as("BigDecimal is sorted to the last", new Object[0])).containsExactly(new boolean[]{true, true, false});
    }

    @Test
    public void isIndexableForNodeWithBigDecimal() {
        RuleBaseConfiguration config = this.getRuleBaseConfiguration();
        FakeBetaNodeFieldConstraint bigDecimalEqualsConstraint = new FakeBetaNodeFieldConstraint(ConstraintTypeOperator.EQUAL, new FakeReadAccessor(ValueType.BIG_DECIMAL_TYPE));
        BetaNodeFieldConstraint[] constraints = new FakeBetaNodeFieldConstraint[]{bigDecimalEqualsConstraint};
        boolean[] indexed = IndexUtil.isIndexableForNode((IndexPrecedenceOption)IndexPrecedenceOption.EQUALITY_PRIORITY, (short)181, (int)config.getCompositeKeyDepth(), (BetaNodeFieldConstraint[])constraints, (KieBaseConfiguration)config);
        ((AbstractBooleanArrayAssert)Assertions.assertThat((boolean[])indexed).as("BigDecimal is not indexed", new Object[0])).containsExactly(new boolean[]{false});
    }

    static class FakeReadAccessor
    implements ReadAccessor {
        private final ValueType valueType;

        private FakeReadAccessor(ValueType valueType) {
            this.valueType = valueType;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public ValueType getValueType() {
            return this.valueType;
        }

        public Class<?> getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public String getNativeReadMethodName() {
            return null;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIndex() {
            return 0;
        }

        public Object getValue(ValueResolver valueResolver, Object object) {
            return null;
        }

        public char getCharValue(ValueResolver valueResolver, Object object) {
            return '\u0000';
        }

        public int getIntValue(ValueResolver valueResolver, Object object) {
            return 0;
        }

        public byte getByteValue(ValueResolver valueResolver, Object object) {
            return 0;
        }

        public short getShortValue(ValueResolver valueResolver, Object object) {
            return 0;
        }

        public long getLongValue(ValueResolver valueResolver, Object object) {
            return 0L;
        }

        public float getFloatValue(ValueResolver valueResolver, Object object) {
            return 0.0f;
        }

        public double getDoubleValue(ValueResolver valueResolver, Object object) {
            return 0.0;
        }

        public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
            return false;
        }

        public boolean isNullValue(ValueResolver valueResolver, Object object) {
            return false;
        }

        public int getHashCode(ValueResolver valueResolver, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }
    }

    static class FakeBetaNodeFieldConstraint
    implements BetaNodeFieldConstraint,
    IndexableConstraint {
        private ConstraintTypeOperator constraintType;
        private ReadAccessor fieldExtractor;

        public FakeBetaNodeFieldConstraint() {
        }

        public FakeBetaNodeFieldConstraint(ConstraintTypeOperator constraintType, ReadAccessor fieldExtractor) {
            this.constraintType = constraintType;
            this.fieldExtractor = fieldExtractor;
        }

        public boolean isUnification() {
            return false;
        }

        public boolean isIndexable(short nodeType, KieBaseConfiguration config) {
            return false;
        }

        public ConstraintTypeOperator getConstraintType() {
            return this.constraintType;
        }

        public FieldValue getField() {
            return null;
        }

        public FieldIndex getFieldIndex() {
            return new FieldIndex(this.fieldExtractor, (TupleValueExtractor)new Declaration("$p1", this.fieldExtractor, null));
        }

        public ReadAccessor getFieldExtractor() {
            return this.fieldExtractor;
        }

        public TupleValueExtractor getIndexExtractor() {
            return null;
        }

        public boolean isAllowedCachedLeft(ContextEntry context, FactHandle handle) {
            return false;
        }

        public boolean isAllowedCachedRight(BaseTuple tuple, ContextEntry context) {
            return false;
        }

        public ContextEntry createContextEntry() {
            return null;
        }

        public BetaNodeFieldConstraint cloneIfInUse() {
            return null;
        }

        public Declaration[] getRequiredDeclarations() {
            return new Declaration[0];
        }

        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        }

        public Constraint clone() {
            return null;
        }

        public Constraint.ConstraintType getType() {
            return null;
        }

        public boolean isTemporal() {
            return false;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

