/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.drools.base.time.Trigger;

public class CompositeMaxDurationTrigger
implements Trigger,
Externalizable {
    private Trigger timerTrigger;
    private Date maxDurationTimestamp;
    private Date timerCurrentDate;

    public CompositeMaxDurationTrigger() {
    }

    public CompositeMaxDurationTrigger(Date maxDurationTimestamp, Trigger timerTrigger) {
        this.maxDurationTimestamp = maxDurationTimestamp;
        this.timerTrigger = timerTrigger;
        if (this.timerTrigger != null) {
            while (this.timerTrigger.hasNextFireTime() != null && this.timerTrigger.hasNextFireTime().getTime() <= this.maxDurationTimestamp.getTime()) {
                this.timerTrigger.nextFireTime();
            }
        }
    }

    public Date hasNextFireTime() {
        if (this.maxDurationTimestamp != null) {
            return this.maxDurationTimestamp;
        }
        if (this.timerTrigger != null) {
            return this.timerTrigger.hasNextFireTime();
        }
        return null;
    }

    public Date nextFireTime() {
        if (this.maxDurationTimestamp != null) {
            this.maxDurationTimestamp = null;
        }
        if (this.timerTrigger != null) {
            return this.timerTrigger.nextFireTime();
        }
        return null;
    }

    public Date getTimerCurrentDate() {
        return this.timerCurrentDate;
    }

    public void setTimerCurrentDate(Date timerCurrentDate) {
        this.timerCurrentDate = timerCurrentDate;
    }

    public Trigger getTimerTrigger() {
        return this.timerTrigger;
    }

    public void setTimerTrigger(Trigger timerTrigger) {
        this.timerTrigger = timerTrigger;
    }

    public Date getMaxDurationTimestamp() {
        return this.maxDurationTimestamp;
    }

    public void setMaxDurationTimestamp(Date maxDurationTimestamp) {
        this.maxDurationTimestamp = maxDurationTimestamp;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.maxDurationTimestamp);
        out.writeObject(this.timerCurrentDate);
        out.writeObject(this.timerTrigger);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.maxDurationTimestamp = (Date)in.readObject();
        this.timerCurrentDate = (Date)in.readObject();
        this.timerTrigger = (Trigger)in.readObject();
    }
}

