/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.drools.base.time.Trigger;
import org.drools.base.time.impl.Timer;
import org.drools.core.time.impl.CompositeMaxDurationTimer;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.IntervalTimer;
import org.junit.Test;

public class CompositeMaxDurationTimerTest {
    @Test
    public void testJustMaxDuration() {
        CompositeMaxDurationTimer timer = new CompositeMaxDurationTimer();
        timer.addDurationTimer(new DurationTimer(25L));
        timer.addDurationTimer(new DurationTimer(50L));
        timer.addDurationTimer(new DurationTimer(70L));
        Date timestamp = new Date();
        Trigger trigger = timer.createTrigger(timestamp.getTime(), null, null, null, null, null, null);
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isEqualTo((Object)new Date(timestamp.getTime() + 70L));
        Assertions.assertThat((Date)trigger.nextFireTime()).isNull();
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isNull();
    }

    @Test
    public void testMixedDurationAndTimer() {
        CompositeMaxDurationTimer timer = new CompositeMaxDurationTimer();
        timer.addDurationTimer(new DurationTimer(25L));
        timer.addDurationTimer(new DurationTimer(50L));
        timer.addDurationTimer(new DurationTimer(70L));
        timer.setTimer((Timer)new IntervalTimer(null, null, 6, 40L, 25L));
        Date timestamp = new Date();
        Trigger trigger = timer.createTrigger(timestamp.getTime(), null, null, null, null, null, null);
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isEqualTo((Object)new Date(timestamp.getTime() + 70L));
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo((Object)new Date(timestamp.getTime() + 90L));
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo((Object)new Date(timestamp.getTime() + 115L));
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo((Object)new Date(timestamp.getTime() + 140L));
        Assertions.assertThat((Date)trigger.nextFireTime()).isNull();
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isNull();
    }
}

