/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.facttemplates;

import org.assertj.core.api.Assertions;
import org.drools.base.base.ObjectType;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.facttemplates.Fact;
import org.drools.base.facttemplates.FactTemplate;
import org.drools.base.facttemplates.FactTemplateFieldExtractor;
import org.drools.base.facttemplates.FactTemplateImpl;
import org.drools.base.facttemplates.FactTemplateObjectType;
import org.drools.base.facttemplates.FieldTemplate;
import org.drools.base.facttemplates.FieldTemplateImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.core.reteoo.CoreComponentFactory;
import org.junit.Test;

public class FactTemplateFieldExtractorTest {
    @Test
    public void testExtractor() {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateFieldExtractor extractName = new FactTemplateFieldExtractor((FactTemplate)cheese, "name");
        FactTemplateFieldExtractor extractPrice = new FactTemplateFieldExtractor((FactTemplate)cheese, "price");
        Fact stilton = cheese.createFact();
        stilton.set("name", (Object)"stilton");
        stilton.set("price", (Object)200);
        Assertions.assertThat((Object)extractName.getValue(null, (Object)stilton)).isEqualTo((Object)"stilton");
        Assertions.assertThat((Object)extractPrice.getValue(null, (Object)stilton)).isEqualTo((Object)200);
        Assertions.assertThat((boolean)extractName.isNullValue(null, (Object)stilton)).isFalse();
        stilton.set("name", null);
        Assertions.assertThat((boolean)extractName.isNullValue(null, (Object)stilton)).isTrue();
        Assertions.assertThat((boolean)extractPrice.isNullValue(null, (Object)stilton)).isFalse();
        Fact brie = cheese.createFact();
        brie.set("name", (Object)"brie");
        brie.set("price", (Object)55);
        Assertions.assertThat((Object)extractName.getValue(null, (Object)brie)).isEqualTo((Object)"brie");
        Assertions.assertThat((Object)extractPrice.getValue(null, (Object)brie)).isEqualTo((Object)55);
        Assertions.assertThat((boolean)extractName.isNullValue(null, (Object)brie)).isFalse();
        brie.set("name", null);
        Assertions.assertThat((boolean)extractName.isNullValue(null, (Object)brie)).isTrue();
        Assertions.assertThat((boolean)extractPrice.isNullValue(null, (Object)stilton)).isFalse();
    }

    @Test
    public void testDeclaration() {
        InternalKnowledgePackage pkg = CoreComponentFactory.get().createKnowledgePackage("org.store");
        FieldTemplateImpl cheeseName = new FieldTemplateImpl("name", String.class);
        FieldTemplateImpl cheesePrice = new FieldTemplateImpl("price", Integer.class);
        FieldTemplate[] fields = new FieldTemplate[]{cheeseName, cheesePrice};
        FactTemplateImpl cheese = new FactTemplateImpl(pkg, "Cheese", fields);
        FactTemplateFieldExtractor extractName = new FactTemplateFieldExtractor((FactTemplate)cheese, "name");
        Pattern pattern = new Pattern(0, (ObjectType)new FactTemplateObjectType((FactTemplate)cheese));
        Declaration declaration = new Declaration("typeOfCheese", (ReadAccessor)extractName, pattern);
        Fact brie = cheese.createFact();
        brie.set("name", (Object)"brie");
        brie.set("price", (Object)55);
        Assertions.assertThat((Object)declaration.getValue(null, (Object)brie)).isEqualTo((Object)"brie");
    }
}

