/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.lang.reflect.Field;
import org.assertj.core.api.Assertions;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.junit.Test;

public class ObjectSourceTest {
    @Test
    public void testObjectSourceConstructor() {
        MockObjectSource source = new MockObjectSource(15);
        Assertions.assertThat((int)source.getId()).isEqualTo(15);
        Assertions.assertThat((int)source.getAttached()).isEqualTo(0);
        source.attach();
        Assertions.assertThat((int)source.getAttached()).isEqualTo(1);
    }

    @Test
    public void testAddObjectSink() throws Exception {
        MockObjectSource source = new MockObjectSource(15);
        Field field = ObjectSource.class.getDeclaredField("sink");
        field.setAccessible(true);
        ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isSameAs((Object)EmptyObjectSinkAdapter.getInstance());
        MockObjectSink sink1 = new MockObjectSink();
        source.addObjectSink((ObjectSink)sink1);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isInstanceOf(SingleObjectSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(1);
        MockObjectSink sink2 = new MockObjectSink();
        source.addObjectSink((ObjectSink)sink2);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isInstanceOf(CompositeObjectSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(2);
        MockObjectSink sink3 = new MockObjectSink();
        source.addObjectSink((ObjectSink)sink3);
        Assertions.assertThat((Object)sink).isInstanceOf(CompositeObjectSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(3);
        source.removeObjectSink((ObjectSink)sink2);
        Assertions.assertThat((Object)sink).isInstanceOf(CompositeObjectSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(2);
        source.removeObjectSink((ObjectSink)sink1);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isInstanceOf(SingleObjectSinkAdapter.class);
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(1);
        source.removeObjectSink((ObjectSink)sink3);
        sink = (ObjectSinkPropagator)field.get((Object)source);
        Assertions.assertThat((Object)sink).isSameAs((Object)EmptyObjectSinkAdapter.getInstance());
        Assertions.assertThat((Object[])sink.getSinks()).hasSize(0);
    }
}

