/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.util.FieldIndex;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.TupleList;

public class TupleIndexHashTable
extends AbstractHashTable
implements TupleMemory {
    private static final long serialVersionUID = 510L;
    public static final int PRIME = 31;
    private int startResult;
    private transient FieldIndexHashTableFullIterator tupleValueFullIterator;
    private transient FullFastIterator fullFastIterator;
    private int factSize;
    private AbstractHashTable.Index index;
    private boolean left;

    public TupleIndexHashTable() {
    }

    public TupleIndexHashTable(FieldIndex[] index, boolean left) {
        this(128, 0.75f, index, left);
    }

    public TupleIndexHashTable(int capacity, float loadFactor, FieldIndex[] index, boolean left) {
        super(capacity, loadFactor);
        this.left = left;
        this.startResult = 31;
        for (FieldIndex i : index) {
            this.startResult += 31 * this.startResult + i.getRightExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startResult = in.readInt();
        this.factSize = in.readInt();
        this.index = (AbstractHashTable.Index)in.readObject();
        this.left = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startResult);
        out.writeInt(this.factSize);
        out.writeObject(this.index);
        out.writeBoolean(this.left);
    }

    public void init(TupleList[] table, int size, int factSize) {
        this.table = table;
        this.size = size;
        this.factSize = factSize;
    }

    @Override
    public Iterator<Tuple> iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        } else {
            this.tupleValueFullIterator.reset();
        }
        return this.tupleValueFullIterator;
    }

    @Override
    public FastIterator<Tuple> fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator<Tuple> fullFastIterator() {
        if (this.fullFastIterator == null) {
            this.fullFastIterator = new FullFastIterator(this.table);
        } else {
            this.fullFastIterator.reset(this.table);
        }
        return this.fullFastIterator;
    }

    @Override
    public FastIterator<Tuple> fullFastIterator(Tuple tuple) {
        this.fullFastIterator.resume(tuple.getMemory(), this.table);
        return this.fullFastIterator;
    }

    @Override
    public Tuple getFirst(Tuple tuple) {
        TupleList bucket = this.get(tuple, !this.left);
        return bucket != null ? bucket.getFirst() : null;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    @Override
    public int getResizeHashcode(TupleList entry) {
        return entry.hashCode();
    }

    @Override
    public Tuple[] toArray() {
        Tuple[] result = new Tuple[this.factSize];
        int index = 0;
        TupleList[] tupleListArray = this.table;
        int n = tupleListArray.length;
        for (int i = 0; i < n; ++i) {
            for (TupleList bucket = tupleListArray[i]; bucket != null; bucket = bucket.getNext()) {
                for (Tuple entry = bucket.getFirst(); entry != null; entry = (Tuple)entry.getNext()) {
                    result[index++] = entry;
                }
            }
        }
        return result;
    }

    @Override
    public void removeAdd(Tuple tuple) {
        AbstractHashTable.HashEntry hashEntry;
        try {
            hashEntry = this.index.hashCodeOf(tuple, this.left);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        TupleList memory = tuple.getMemory();
        memory.remove(tuple);
        if (hashEntry.hashCode() == memory.hashCode()) {
            memory.add(tuple);
            return;
        }
        --this.factSize;
        if (memory.getFirst() == null) {
            TupleList current;
            int index = TupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            TupleList previous = null;
            for (current = this.table[index]; current != memory; current = current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.setNext(current.getNext());
            } else {
                this.table[index] = current.getNext();
            }
            --this.size;
        }
        this.add(tuple);
    }

    @Override
    public void add(Tuple tuple) {
        TupleList entry = this.getOrCreate(tuple);
        if (entry != null) {
            entry.add(tuple);
            ++this.factSize;
        }
    }

    @Override
    public void remove(Tuple tuple) {
        TupleList memory = tuple.getMemory();
        memory.remove(tuple);
        --this.factSize;
        if (memory.getFirst() == null) {
            TupleList current;
            int index = TupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            TupleList previous = null;
            for (current = this.table[index]; current != memory; current = current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.setNext(current.getNext());
            } else {
                this.table[index] = current.getNext();
            }
            --this.size;
        }
        tuple.clear();
    }

    private TupleList getOrCreate(Tuple tuple) {
        TupleList entry;
        AbstractHashTable.HashEntry hashEntry;
        try {
            hashEntry = this.index.hashCodeOf(tuple, this.left);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        int index = TupleIndexHashTable.indexOf(hashEntry.hashCode(), this.table.length);
        for (entry = this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matches(entry, hashEntry)) continue;
            return entry;
        }
        entry = new AbstractHashTable.IndexTupleList(this.index, hashEntry.clone());
        entry.setNext(this.table[index]);
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return entry;
    }

    private TupleList get(Tuple tuple, boolean isLeftTuple) {
        AbstractHashTable.HashEntry hashEntry;
        try {
            hashEntry = this.index.hashCodeOf(tuple, isLeftTuple);
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        int index = TupleIndexHashTable.indexOf(hashEntry.hashCode(), this.table.length);
        for (TupleList entry = this.table[index]; entry != null; entry = entry.getNext()) {
            if (!this.matches(entry, hashEntry)) continue;
            return entry;
        }
        return null;
    }

    private boolean matches(TupleList list, AbstractHashTable.HashEntry hashEntry) {
        return list.hashCode() == hashEntry.hashCode() && hashEntry.equals(((AbstractHashTable.IndexTupleList)list).getHashEntry());
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Tuple> it = this.iterator();
        Tuple leftTuple = it.next();
        while (leftTuple != null) {
            builder.append(leftTuple).append("\n");
            leftTuple = it.next();
        }
        return builder.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.startResult = 31;
        this.factSize = 0;
        this.fullFastIterator = null;
        this.tupleValueFullIterator = null;
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.EQUAL;
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator<Tuple> {
        private final AbstractHashTable hashTable;
        private TupleList[] table;
        private int row;
        private int length;
        private TupleList list;
        private Tuple tuple;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
            this.reset();
        }

        @Override
        public Tuple next() {
            while (this.row <= this.length) {
                while (this.list == null) {
                    if (this.row < this.length) {
                        this.list = this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (this.list == null) continue;
                    this.tuple = this.list.getFirst();
                    return this.tuple;
                }
                this.tuple = (Tuple)this.tuple.getNext();
                if (this.tuple != null) {
                    return this.tuple;
                }
                this.list = this.list.getNext();
                if (this.list == null) continue;
                this.tuple = this.list.getFirst();
                return this.tuple;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("FieldIndexHashTableFullIterator does not support remove().");
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = 0;
            this.list = null;
            this.tuple = null;
        }
    }

    public static class FullFastIterator
    implements FastIterator<Tuple> {
        private TupleList[] table;
        private int row;

        public FullFastIterator(TupleList[] table) {
            this.table = table;
            this.row = 0;
        }

        public void resume(TupleList target, TupleList[] table) {
            this.table = table;
            this.row = TupleIndexHashTable.indexOf(target.hashCode(), this.table.length);
            ++this.row;
        }

        @Override
        public Tuple next(Tuple tuple) {
            TupleList list = null;
            if (tuple != null) {
                list = tuple.getMemory();
            }
            int length = this.table.length;
            while (this.row <= length) {
                while (list == null) {
                    if (this.row < length) {
                        list = this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (list == null) continue;
                    tuple = list.getFirst();
                    return tuple;
                }
                if ((tuple = (Tuple)tuple.getNext()) != null) {
                    return tuple;
                }
                if ((list = list.getNext()) == null) continue;
                tuple = list.getFirst();
                return tuple;
            }
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }

        public void reset(TupleList[] table) {
            this.table = table;
            this.row = 0;
        }
    }
}

