/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.core.common.ActivationGroupImpl;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.AgendaGroupsManager;
import org.drools.core.common.InternalActivationGroup;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.concurrent.GroupEvaluator;
import org.drools.core.concurrent.SequentialGroupEvaluator;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.SynchronizedPropagationList;
import org.drools.core.reteoo.AgendaComponentFactory;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.util.LinkedList;
import org.drools.util.StringUtils;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.AgendaFilter;

public class ActivationsManagerImpl
implements ActivationsManager {
    private final ReteEvaluator reteEvaluator;
    private final AgendaGroupsManager agendaGroupsManager;
    private int activationCounter = 0;
    private final AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    private final Map<String, InternalActivationGroup> activationGroups = new HashMap<String, InternalActivationGroup>();
    private final PropagationList propagationList;
    private final GroupEvaluator groupEvaluator;
    private boolean firing = false;
    private final LinkedList<RuleAgendaItem> eager = new LinkedList();
    private final Map<QueryImpl, RuleAgendaItem> queries = new ConcurrentHashMap<QueryImpl, RuleAgendaItem>();
    private List<PropagationContext> expirationContexts;

    public ActivationsManagerImpl(ReteEvaluator reteEvaluator) {
        this.reteEvaluator = reteEvaluator;
        this.agendaGroupsManager = new AgendaGroupsManager.SimpleAgendaGroupsManager(reteEvaluator);
        this.propagationList = new SynchronizedPropagationList(reteEvaluator);
        this.groupEvaluator = new SequentialGroupEvaluator(this);
        if (reteEvaluator.getKnowledgeBase().getRuleBaseConfiguration().getEventProcessingMode() == EventProcessingOption.STREAM) {
            this.expirationContexts = new ArrayList<PropagationContext>();
        }
    }

    @Override
    public ReteEvaluator getReteEvaluator() {
        return this.reteEvaluator;
    }

    @Override
    public AgendaGroupsManager getAgendaGroupsManager() {
        return this.agendaGroupsManager;
    }

    @Override
    public AgendaEventSupport getAgendaEventSupport() {
        return this.agendaEventSupport;
    }

    @Override
    public ActivationsFilter getActivationsFilter() {
        return null;
    }

    @Override
    public void addEagerRuleAgendaItem(RuleAgendaItem item) {
        if (item.isInList(this.eager)) {
            return;
        }
        this.eager.add(item);
    }

    @Override
    public void removeEagerRuleAgendaItem(RuleAgendaItem item) {
        if (!item.isInList(this.eager)) {
            return;
        }
        this.eager.remove(item);
    }

    @Override
    public void addQueryAgendaItem(RuleAgendaItem item) {
        this.queries.put((QueryImpl)item.getRule(), item);
    }

    @Override
    public void removeQueryAgendaItem(RuleAgendaItem item) {
        this.queries.remove((QueryImpl)item.getRule());
    }

    @Override
    public void registerExpiration(PropagationContext ectx) {
        this.expirationContexts.add(ectx);
    }

    @Override
    public void clearAndCancelActivationGroup(String name) {
        InternalActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(InternalActivationGroup activationGroup) {
        activationGroup.setTriggeredForRecency(this.reteEvaluator.getFactHandleFactory().getRecency());
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            InternalMatch internalMatch = node.getActivation();
            internalMatch.setActivationGroupNode(null);
            if (!internalMatch.isQueued()) continue;
            internalMatch.remove();
            this.getAgendaEventSupport().fireActivationCancelled(internalMatch, this.reteEvaluator, MatchCancelledCause.CLEAR);
        }
        activationGroup.reset();
    }

    @Override
    public RuleAgendaItem createRuleAgendaItem(int salience, PathMemory pathMemory, TerminalNode rtn) {
        return AgendaComponentFactory.get().createAgendaItem(salience, pathMemory, rtn, false, this.agendaGroupsManager.getMainAgendaGroup());
    }

    @Override
    public InternalMatch createAgendaItem(RuleTerminalNodeLeftTuple rtnLeftTuple, int salience, PropagationContext context, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        rtnLeftTuple.init(this.activationCounter++, salience, context, ruleAgendaItem, agendaGroup);
        return rtnLeftTuple;
    }

    @Override
    public void cancelActivation(InternalMatch internalMatch) {
        InternalMatch item = internalMatch;
        if (internalMatch.isQueued()) {
            if (internalMatch.getActivationGroupNode() != null) {
                internalMatch.getActivationGroupNode().getActivationGroup().removeActivation(internalMatch);
            }
            ((Tuple)((Object)internalMatch)).decreaseActivationCountForEvents();
            this.getAgendaEventSupport().fireActivationCancelled(internalMatch, this.reteEvaluator, MatchCancelledCause.WME_MODIFY);
        }
        if (item.getRuleAgendaItem() != null) {
            item.getRuleAgendaItem().getRuleExecutor().fireConsequenceEvent(this.reteEvaluator, this, item, "$onDeleteMatch$");
        }
        this.reteEvaluator.getRuleEventSupport().onDeleteMatch(item);
    }

    @Override
    public void addItemToActivationGroup(InternalMatch internalMatch) {
        String group = internalMatch.getRule().getActivationGroup();
        if (!StringUtils.isEmpty((CharSequence)group)) {
            InternalActivationGroup actgroup = this.activationGroups.computeIfAbsent(group, k -> new ActivationGroupImpl(this, (String)k));
            if (actgroup.getTriggeredForRecency() != 0L && actgroup.getTriggeredForRecency() >= internalMatch.getPropagationContext().getFactHandle().getRecency()) {
                return;
            }
            actgroup.addActivation(internalMatch);
        }
    }

    @Override
    public RuleAgendaItem peekNextRule() {
        return this.getAgendaGroupsManager().peekNextRule();
    }

    @Override
    public void flushPropagations() {
        this.propagationList.flush();
    }

    @Override
    public boolean isFiring() {
        return this.firing;
    }

    @Override
    public void evaluateEagerList() {
        while (!this.eager.isEmpty()) {
            RuleAgendaItem item = this.eager.removeFirst();
            if (!item.isRuleInUse()) continue;
            this.evaluateQueriesForRule(item);
            RuleExecutor ruleExecutor = item.getRuleExecutor();
            ruleExecutor.evaluateNetwork(this);
        }
    }

    @Override
    public void evaluateQueriesForRule(RuleAgendaItem item) {
        RuleImpl rule = item.getRule();
        if (!rule.isQuery()) {
            for (QueryImpl query : rule.getDependingQueries()) {
                RuleAgendaItem queryAgendaItem = this.queries.remove(query);
                if (queryAgendaItem == null) continue;
                queryAgendaItem.getRuleExecutor().evaluateNetwork(this);
            }
        }
    }

    @Override
    public KnowledgeHelper getKnowledgeHelper() {
        return this.groupEvaluator.getKnowledgeHelper();
    }

    @Override
    public void resetKnowledgeHelper() {
        this.groupEvaluator.resetKnowledgeHelper();
    }

    @Override
    public void haltGroupEvaluation() {
        this.groupEvaluator.haltEvaluation();
    }

    @Override
    public void executeTask(ExecutableEntry executableEntry) {
        executableEntry.execute();
    }

    @Override
    public void addPropagation(PropagationEntry propagationEntry) {
        this.propagationList.addEntry(propagationEntry);
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        return this.fireLoop(agendaFilter, fireLimit, RestHandler.FIRE_ALL_RULES);
    }

    private int fireLoop(AgendaFilter agendaFilter, int fireLimit, RestHandler restHandler) {
        boolean limitReached;
        this.firing = true;
        int fireCount = 0;
        PropagationEntry head = this.propagationList.takeAll();
        boolean bl = limitReached = fireLimit == 0;
        while (this.isFiring()) {
            int returnedFireCount;
            if (head != null) {
                this.propagationList.flush(head);
                head = null;
            }
            this.evaluateEagerList();
            InternalAgendaGroup group = this.getAgendaGroupsManager().getNextFocus();
            if (group != null && !limitReached) {
                returnedFireCount = this.groupEvaluator.evaluateAndFire(group, agendaFilter, fireCount, fireLimit);
                limitReached = fireLimit > 0 && (fireCount += returnedFireCount) >= fireLimit;
                head = this.propagationList.takeAll();
            } else {
                returnedFireCount = 0;
                group = null;
            }
            if (returnedFireCount != 0 || head != null || group != null && (!group.isEmpty() || group.isAutoDeactivate()) || this.flushExpirations()) continue;
            head = restHandler.handleRest(this);
        }
        this.agendaGroupsManager.deactivateMainGroupWhenEmpty();
        return fireCount;
    }

    private boolean flushExpirations() {
        if (this.expirationContexts == null || this.expirationContexts.isEmpty() || this.propagationList.hasEntriesDeferringExpiration()) {
            return false;
        }
        for (PropagationContext ectx : this.expirationContexts) {
            this.doRetract(ectx);
        }
        this.expirationContexts.clear();
        return true;
    }

    private void doRetract(PropagationContext ectx) {
        InternalFactHandle factHandle = (InternalFactHandle)ectx.getFactHandle();
        ObjectTypeNode.retractLeftTuples(factHandle, ectx, this.reteEvaluator);
        ObjectTypeNode.retractRightTuples(factHandle, ectx, this.reteEvaluator);
        if (factHandle.isPendingRemoveFromStore()) {
            String epId = factHandle.getEntryPointName();
            ((InternalWorkingMemoryEntryPoint)this.reteEvaluator.getEntryPoint(epId)).removeFromObjectStore(factHandle);
        }
    }

    static interface RestHandler {
        public static final RestHandler FIRE_ALL_RULES = new FireAllRulesRestHandler();
        public static final RestHandler FIRE_UNTIL_HALT = new FireUntilHaltRestHandler();

        public PropagationEntry handleRest(ActivationsManagerImpl var1);

        public static class FireAllRulesRestHandler
        implements RestHandler {
            @Override
            public PropagationEntry handleRest(ActivationsManagerImpl agenda) {
                PropagationEntry head = agenda.propagationList.takeAll();
                if (head == null) {
                    agenda.firing = false;
                }
                return head;
            }
        }

        public static class FireUntilHaltRestHandler
        implements RestHandler {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PropagationEntry handleRest(ActivationsManagerImpl agenda) {
                PropagationEntry head;
                PropagationList propagationList = agenda.propagationList;
                synchronized (propagationList) {
                    head = agenda.propagationList.takeAll();
                    if (head == null) {
                        agenda.propagationList.waitOnRest();
                        head = agenda.propagationList.takeAll();
                        if (head == null) {
                            agenda.firing = false;
                        }
                    }
                }
                return head;
            }
        }
    }
}

