/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.concurrent;

import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.concurrent.GroupEvaluator;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.kie.api.runtime.rule.AgendaFilter;

public abstract class AbstractGroupEvaluator
implements GroupEvaluator {
    protected final ActivationsManager activationsManager;
    private final boolean sequential;
    private KnowledgeHelper knowledgeHelper;
    private boolean haltEvaluation;

    public AbstractGroupEvaluator(ActivationsManager activationsManager) {
        this.activationsManager = activationsManager;
        this.sequential = activationsManager.getReteEvaluator().getKnowledgeBase().getRuleBaseConfiguration().isSequential();
        this.knowledgeHelper = this.newKnowledgeHelper();
    }

    @Override
    public final int evaluateAndFire(InternalAgendaGroup group, AgendaFilter filter, int fireCount, int fireLimit) {
        this.startEvaluation(group);
        RuleAgendaItem item = this.nextActivation(group);
        int loopFireCount = 0;
        while (!(item == null || this.haltEvaluation || fireLimit >= 0 && fireCount + loopFireCount >= fireLimit)) {
            this.activationsManager.evaluateQueriesForRule(item);
            loopFireCount += item.getRuleExecutor().evaluateNetworkAndFire(this.activationsManager, filter, fireCount, fireLimit);
            this.activationsManager.flushPropagations();
            item = this.nextActivation(group);
        }
        return loopFireCount;
    }

    private KnowledgeHelper newKnowledgeHelper() {
        return this.activationsManager.getReteEvaluator().createKnowledgeHelper();
    }

    private RuleAgendaItem nextActivation(InternalAgendaGroup group) {
        return this.sequential ? group.remove() : group.peek();
    }

    @Override
    public KnowledgeHelper getKnowledgeHelper() {
        return this.knowledgeHelper;
    }

    @Override
    public void resetKnowledgeHelper() {
        this.knowledgeHelper = this.newKnowledgeHelper();
    }

    @Override
    public void haltEvaluation() {
        this.haltEvaluation = true;
    }

    protected void startEvaluation(InternalAgendaGroup group) {
        this.haltEvaluation = false;
    }
}

