/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.Person;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.template.parser.TemplateDataListener;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ExternalSpreadsheetCompilerTest {
    private ExternalSpreadsheetCompiler converter;

    @BeforeEach
    public void setUp() {
        this.converter = new ExternalSpreadsheetCompiler();
    }

    @Test
    public void testLoadFromClassPath() {
        String drl = this.converter.compile("/data/MultiSheetDST.drl.xls", "/templates/test_template1.drl", 11, 2);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("rule \"How cool is Shaun 12\"") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("rule \"How cool is Kumar 11\"") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"import example.model.User;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"import example.model.Car;"});
    }

    @Test
    public void testLoadSpecificWorksheet() {
        String drl = this.converter.compile("/data/MultiSheetDST.drl.xls", "Another Sheet", "/templates/test_template1.drl", 11, 2);
        Assertions.assertThat((String)drl).isNotNull();
    }

    @Test
    public void testLoadCsv() {
        String drl = this.converter.compile("/data/ComplexWorkbook.drl.csv", "/templates/test_template2.drl", InputType.CSV, 10, 2);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("myObject.size () > 2") > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red),\n        myObject.size () > 1") > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        String drl = this.converter.compile("/data/BasicWorkbook.drl.xls", "/templates/test_template3.drl", InputType.XLS, 10, 2);
        String drl1 = this.converter.compile("/data/BasicWorkbook.drl.xls", "/templates/test_template3.drl", InputType.XLS, 21, 2);
        Assertions.assertThat((String)drl).isNotNull();
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assertions.assertThat((boolean)m.matches()).isTrue();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"This is a function block"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"global Class1 obj1;"});
        Assertions.assertThat((String)drl1).contains(new CharSequence[]{"myObject.setIsValid(10-Jul-1974)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.getColour().equals(blue)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"Foo(myObject.getColour().equals(red), myObject.size() > 12\")"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"b: Bar()\n        eval(myObject.size() < 3)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"b: Bar()\n        eval(myObject.size() < 9)"});
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testLoadBasicWithExtraCells() {
        String drl = this.converter.compile("/data/BasicWorkbook.drl.xls", "/templates/test_template4.drl", InputType.XLS, 10, 2);
        Assertions.assertThat((String)drl).isNotNull();
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"This is a function block"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"global Class1 obj1;"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"myObject.getColour().equals(blue)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"Foo(myObject.getColour().equals(red), myObject.size() > 12\")"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"b: Bar()\n        eval(myObject.size() < 3)"});
        Assertions.assertThat((String)drl).contains(new CharSequence[]{"b: Bar()\n        eval(myObject.size() < 9)"});
        Assertions.assertThat((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testIntegration() throws Exception {
        String drl = this.converter.compile("/data/IntegrationExampleTestForTemplates.drl.xls", "/templates/test_integration.drl", 18, 3);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = kbase.newKieSession();
        kSession.insert((Object)new Cheese("stilton", 42.0));
        kSession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assertions.assertThat(list).hasSize(1);
    }

    @Test
    public void testPricing() throws Exception {
        ArrayList<TemplateDataListener> listeners = new ArrayList<TemplateDataListener>();
        TemplateDataListener l1 = new TemplateDataListener(10, 3, "/templates/test_pricing1.drl");
        listeners.add(l1);
        TemplateDataListener l2 = new TemplateDataListener(30, 3, "/templates/test_pricing2.drl");
        listeners.add(l2);
        this.converter.compile("/data/ExamplePolicyPricing.drl.xls", InputType.XLS, listeners);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])l1.renderDRL().getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])l2.renderDRL().getBytes()), ResourceType.DRL);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = kbase.newKieSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        kSession.insert((Object)driver);
        kSession.insert((Object)policy);
        kSession.fireAllRules();
        int basePrice = policy.getBasePrice();
        Assertions.assertThat((int)basePrice).isEqualTo(120);
    }
}

