/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.acme.insurance.launcher.PricingRuleLauncher;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class SpreadsheetIntegrationExampleTest {
    private KieSession ksession;

    @AfterEach
    public void tearDown() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testExecuteUsingKieAPI() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.drl.xls", this.getClass());
        this.ksession = this.getKieSession(dt);
        this.ksession.insert((Object)new Cheese("stilton", 42.0));
        this.ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        ((ListAssert)Assertions.assertThat(list).hasSize(1)).containsExactly((Object[])new String[]{"Old man stilton"});
    }

    private KieSession getKieSession(Resource dt) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(dt);
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assertions.assertThat((List)kb.getResults().getMessages()).isEmpty();
        return ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testExecuteJBRULES3005() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.drl.xls", this.getClass());
        this.ksession = this.getKieSession(dt);
        this.ksession.insert((Object)new Cheese("stilton", 42.0));
        this.ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        ((ListAssert)Assertions.assertThat(list).hasSize(1)).containsExactly((Object[])new String[]{"Old man stilton"});
    }

    @Test
    public void testNamedWorksheet() throws Exception {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        dtconf.setWorksheetName("Tables_2");
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.drl.xls", this.getClass()).setConfiguration((ResourceConfiguration)dtconf);
        this.ksession = this.getKieSession(dt);
        this.ksession.insert((Object)new Cheese("cheddar", 42.0));
        this.ksession.insert((Object)new Person("michael", "stilton", 25));
        ArrayList list = new ArrayList();
        this.ksession.setGlobal("list", list);
        this.ksession.fireAllRules();
        ((ListAssert)Assertions.assertThat(list).hasSize(1)).containsExactly((Object[])new String[]{"Young man cheddar"});
    }

    @Test
    public void testInsuranceExample() throws Exception {
        PricingRuleLauncher launcher = new PricingRuleLauncher();
        Assertions.assertThat((int)launcher.executeExample()).isEqualTo(120);
    }

    @Test
    public void testBooleanField() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/ShopRules.drl.xls", this.getClass());
        this.ksession = this.getKieSession(dt);
        Person p = new Person("michael", "stilton", 42);
        this.ksession.insert((Object)p);
        this.ksession.fireAllRules();
        Assertions.assertThat((Boolean)p.getCanBuyAlcohol()).isTrue();
    }

    @Test
    public void testHeadingWhitespace() throws Exception {
        System.setProperty("drools.trimCellsInDTable", "false");
        try {
            Resource dt = ResourceFactory.newClassPathResource((String)"/data/HeadingWhitespace.drl.xls", this.getClass());
            this.ksession = this.getKieSession(dt);
            Person p = new Person(" me");
            this.ksession.insert((Object)p);
            this.ksession.fireAllRules();
            Assertions.assertThat((Boolean)p.getCanBuyAlcohol()).isTrue();
        }
        finally {
            System.clearProperty("drools.trimCellsInDTable");
        }
    }

    @Test
    public void testPackageName() throws Exception {
        KieServices ks = KieServices.get();
        KieModuleModel kmodel = ks.newKieModuleModel();
        kmodel.newKieBaseModel("kbase1").addPackage("org.drools.simple.candrink").setDefault(true);
        KieBase kbase = new KieHelper().setKieModuleModel(kmodel).addResource(ks.getResources().newClassPathResource("/data/CanNotDrink2.drl.xls", this.getClass()), ResourceType.DTABLE).build(new KieBaseOption[0]);
        Assertions.assertThat((Collection)kbase.getKiePackage("org.drools.simple.candrink").getRules()).hasSize(2);
    }
}

