/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.kie.api.command.Command;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;

public class UnicodeInCSVTest {
    private KieSession ksession;

    @AfterEach
    public void tearDown() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testUnicodeCSVDecisionTable() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.CSV);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"unicode.drl.csv", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors().toString());
            System.out.println(DecisionTableFactory.loadFromInputStream((InputStream)this.getClass().getResourceAsStream("unicode.drl.xls"), (DecisionTableConfiguration)dtconf));
            Assertions.fail((String)("Cannot build CSV decision table containing utf-8 characters\n" + kbuilder.getErrors().toString()));
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        this.ksession = kbase.newKieSession();
        ArrayList<Command> commands = new ArrayList<Command>();
        ArrayList dosp\u011bl\u00ed = new ArrayList();
        commands.add(CommandFactory.newSetGlobal((String)"dosp\u011bl\u00ed", dosp\u011bl\u00ed));
        \u010clov\u011bk \u0158eho\u0159 = new \u010clov\u011bk();
        \u0158eho\u0159.setV\u011bk(30);
        \u0158eho\u0159.setJm\u00e9no("\u0158eho\u0159");
        commands.add(CommandFactory.newInsert((Object)\u0158eho\u0159));
        commands.add(CommandFactory.newFireAllRules());
        this.ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        Assertions.assertThat((Object)kbase.getRule("org.drools.decisiontable", "p\u0159idej k dosp\u011bl\u00fdm")).isNotNull();
        Assertions.assertThat(dosp\u011bl\u00ed).hasSize(5);
        Assertions.assertThat((String)((\u010clov\u011bk)dosp\u011bl\u00ed.iterator().next()).getJm\u00e9no()).isEqualTo("\u0158eho\u0159");
        Assertions.assertThat((Object)kbase.getRule("org.drools.decisiontable", "\u043f\u0440\u0438\u0432\u0435\u0442 \u043c\u0438\u0440")).isNotNull();
        Assertions.assertThat((Object)kbase.getRule("org.drools.decisiontable", "\u4f60\u597d\u4e16\u754c")).isNotNull();
        Assertions.assertThat((Object)kbase.getRule("org.drools.decisiontable", "hall\u00e5 v\u00e4rlden")).isNotNull();
        Assertions.assertThat((Object)kbase.getRule("org.drools.decisiontable", "\u0645\u0631\u062d\u0628\u0627 \u0627\u0644\u0639\u0627\u0644\u0645")).isNotNull();
    }

    public static class \u010clov\u011bk {
        private int v\u011bk;
        private String jm\u00e9no;

        public void setV\u011bk(int v\u011bk) {
            this.v\u011bk = v\u011bk;
        }

        public int getV\u011bk() {
            return this.v\u011bk;
        }

        public void setJm\u00e9no(String jm\u00e9no) {
            this.jm\u00e9no = jm\u00e9no;
        }

        public String getJm\u00e9no() {
            return this.jm\u00e9no;
        }
    }
}

