/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.assertj.core.api.Assertions;
import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Column;
import org.drools.template.parser.ColumnFactory;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.StringColumn;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColumnFactoryTest {
    private ColumnFactory f;

    @BeforeEach
    public void setUp() {
        this.f = new ColumnFactory();
    }

    @Test
    public void testGetColumn() {
        Column column = this.f.getColumn("column");
        Assertions.assertThat((Object)column).isInstanceOf(StringColumn.class);
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
    }

    @Test
    public void testGetStringArrayColumn() {
        Column column = this.f.getColumn("column: String[]");
        Assertions.assertThat((Object)column).isInstanceOf(ArrayColumn.class);
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("StringCell");
    }

    @Test
    public void testGetLongArrayColumn() {
        Column column = this.f.getColumn("column: Long[]");
        Assertions.assertThat((Object)column).isInstanceOf(ArrayColumn.class);
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("LongCell");
    }

    @Test
    public void testGetArrayColumnSimple() {
        Column column = this.f.getColumn("column[]");
        Assertions.assertThat((Object)column).isInstanceOf(ArrayColumn.class);
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
        Assertions.assertThat((String)column.getCellType()).isEqualTo("StringCell");
    }

    @Test
    public void testGetLongColumn() {
        Column column = this.f.getColumn("column: Long");
        Assertions.assertThat((Object)column).isInstanceOf(LongColumn.class);
        Assertions.assertThat((String)column.getName()).isEqualTo("column");
    }

    @Test
    public void testInvalidGetColumn() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.f.getColumn("column$"));
    }
}

