/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.LhsBuilder;
import org.junit.jupiter.api.Test;

public class LhsBuilderTest {
    private LhsBuilder builder;

    @Test
    public void testBuildItUp() throws Exception {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "age");
        this.builder.addTemplate(10, 2, "size != $param");
        this.builder.addTemplate(10, 3, "date <");
        this.builder.addCellValue(11, 1, "42");
        this.builder.addCellValue(11, 2, "20");
        this.builder.addCellValue(11, 3, "30");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age == \"42\", size != 20, date < \"30\")");
        this.builder.clearValues();
        this.builder.addCellValue(12, 2, "42");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(size != 42)");
    }

    @Test
    public void testEmptyCells() {
        this.builder = new LhsBuilder(9, 1, "Person");
        Assertions.assertThat((boolean)this.builder.hasValues()).isFalse();
    }

    @Test
    public void testClassicMode() {
        this.builder = new LhsBuilder(9, 1, "");
        this.builder.addTemplate(10, 1, "Person(age < $param)");
        this.builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42)");
        this.builder = new LhsBuilder(9, 3, null);
        this.builder.addTemplate(10, 3, "Foo(bar == $param)");
        this.builder.addTemplate(10, 4, "eval(true)");
        this.builder.addCellValue(11, 3, "42");
        this.builder.addCellValue(11, 4, "Y");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Foo(bar == 42)\neval(true)");
    }

    @Test
    public void testForAllAndFunction() {
        this.builder = new LhsBuilder(9, 1, "");
        this.builder.addTemplate(10, 1, "forall(&&){Foo(bar != $)}");
        this.builder.addCellValue(11, 1, "42,43");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Foo(bar != 42) && Foo(bar != 43)");
    }

    @Test
    public void testForAllOr() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "forall(||){age < $}");
        this.builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42)");
    }

    @Test
    public void testForAllOrPrefix() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "age < 10 && forall(||){age < $}");
        this.builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 10 && age < 42)");
    }

    @Test
    public void testForAllOrCSV() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "forall(||){age < $}");
        this.builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42 || age < 43 || age < 44)");
    }

    @Test
    public void testForAllAnd() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "forall(&&){age < $}");
        this.builder.addCellValue(11, 1, "42");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42)");
    }

    @Test
    public void testForAllAndCSV() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "forall(&&){age < $}");
        this.builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42 && age < 43 && age < 44)");
    }

    @Test
    public void testForAllAndForAllOrCSVMultiple() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "forall(&&){age < $ || age == $}");
        this.builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44)");
    }

    @Test
    public void testForAllsAndForAllOrCSVMultiple() {
        this.builder = new LhsBuilder(9, 1, "Person");
        this.builder.addTemplate(10, 1, "forall(&&){age < $ || age == $} && forall(&&){age < $ || age == $}");
        this.builder.addCellValue(11, 1, "42, 43, 44");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Person(age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44 && age < 42 || age == 42 && age < 43 || age == 43 && age < 44 || age == 44)");
    }

    @Test
    public void testIdentifyFieldTypes() {
        this.builder = new LhsBuilder(9, 1, "");
        Assertions.assertThat((Comparable)this.builder.calcFieldType("age")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("age <")).isEqualTo((Object)LhsBuilder.FieldType.OPERATOR_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("age < $param")).isEqualTo((Object)LhsBuilder.FieldType.NORMAL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(||){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(&&){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(,){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(){age < $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(){age < $} && forall(){age == $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("x && forall(){age < $} && forall(){age == $}")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("x && forall(){age < $} && forall(){age == $} && y")).isEqualTo((Object)LhsBuilder.FieldType.FORALL_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("age < $para")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall{||}{age < $}")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(){}")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(){age < $")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(){,")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall({})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall({}){test})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(&&){{}})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
        Assertions.assertThat((Comparable)this.builder.calcFieldType("forall(&&){{})")).isEqualTo((Object)LhsBuilder.FieldType.SINGLE_FIELD);
    }

    @Test
    public void testIdentifyColumnCorrectly() {
        this.builder = new LhsBuilder(9, 1, null);
        Assertions.assertThat((boolean)this.builder.isMultipleConstraints()).isFalse();
        this.builder = new LhsBuilder(9, 1, "Foo");
        Assertions.assertThat((boolean)this.builder.isMultipleConstraints()).isTrue();
        this.builder = new LhsBuilder(9, 1, "f:Foo() eval  ");
        Assertions.assertThat((boolean)this.builder.isMultipleConstraints()).isTrue();
        this.builder = new LhsBuilder(9, 1, "f: Foo()");
        Assertions.assertThat((boolean)this.builder.isMultipleConstraints()).isTrue();
    }

    @Test
    public void testTypeConst3() {
        this.builder = new LhsBuilder(9, 1, "Type");
        this.builder.addTemplate(10, 1, "flda");
        this.builder.addTemplate(10, 2, "fldb >");
        this.builder.addTemplate(10, 3, "fldc str[startsWith]");
        this.builder.addCellValue(11, 1, "good");
        this.builder.addCellValue(11, 2, "42");
        this.builder.addCellValue(11, 3, "abc");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Type(flda == \"good\", fldb > \"42\", fldc str[startsWith] \"abc\")");
    }

    @Test
    public void testTypeParConst2() {
        this.builder = new LhsBuilder(9, 1, "Type()");
        this.builder.addTemplate(10, 1, "flda");
        this.builder.addTemplate(10, 2, "fldb >");
        this.builder.addCellValue(11, 1, "good");
        this.builder.addCellValue(11, 2, "42");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Type(flda == \"good\", fldb > \"42\")");
    }

    @Test
    public void testTypeConstFrom() {
        this.builder = new LhsBuilder(9, 1, "Type from $west");
        this.builder.addTemplate(10, 1, "flda");
        this.builder.addCellValue(11, 1, "good");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Type(flda == \"good\") from $west");
    }

    @Test
    public void testTypeEvalExp2() {
        this.builder = new LhsBuilder(9, 1, "Type($a:a,$b:b) eval");
        this.builder.addTemplate(10, 1, "$a > $param");
        this.builder.addTemplate(10, 2, "$b < $param");
        this.builder.addCellValue(11, 1, "1");
        this.builder.addCellValue(11, 2, "99");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Type($a:a,$b:b) eval($a > 1 && $b < 99)");
    }

    @Test
    public void testEvalExp2() {
        this.builder = new LhsBuilder(9, 1, "eval()");
        this.builder.addTemplate(10, 1, "$a > $param");
        this.builder.addTemplate(10, 2, "$b < $param");
        this.builder.addCellValue(11, 1, "1");
        this.builder.addCellValue(11, 2, "99");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("eval($a > 1 && $b < 99)");
    }

    @Test
    public void testTypeParPlain() {
        this.builder = new LhsBuilder(9, 1, null);
        this.builder.addTemplate(10, 1, "Type()");
        this.builder.addCellValue(11, 1, "x");
        Assertions.assertThat((String)this.builder.getResult()).isEqualTo("Type()");
    }
}

