/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class ExcelParserTest {
    private static final String LAST_CELL_VALUE = "last";
    private static final String FIRST_CELL_CONTENT = "first";
    private Workbook workbook;
    private Sheet sheet;

    @AfterEach
    public void tearDown() throws IOException {
        if (this.workbook != null) {
            this.workbook.close();
        }
    }

    @Test
    public void testCellMerge() throws Exception {
        ExcelParser parser = new ExcelParser((Map)null);
        this.workbook = new XSSFWorkbook();
        this.sheet = this.workbook.createSheet();
        this.createCell(2, 2, FIRST_CELL_CONTENT);
        this.createCell(7, 5, LAST_CELL_VALUE);
        Cell cell = this.sheet.createRow(1).createCell(1);
        CellRangeAddress[] ranges = new CellRangeAddress[]{new CellRangeAddress(2, 7, 2, 5)};
        Assertions.assertThat((Iterable)parser.getRangeIfMerged(cell, ranges)).isNull();
        this.updateCell(2, 5, "wrong");
        Cell wrongCell = this.getCell(2, 5);
        CellRangeAddress rangeIfMerged = parser.getRangeIfMerged(wrongCell, ranges);
        Assertions.assertThat((String)this.sheet.getRow(rangeIfMerged.getFirstRow()).getCell(rangeIfMerged.getFirstColumn()).getStringCellValue()).isEqualTo(FIRST_CELL_CONTENT);
    }

    private void createCell(int row, int column, String value) {
        Cell cell = this.sheet.createRow(row).createCell(column);
        cell.setCellValue(value);
    }

    private void updateCell(int row, int column, String value) {
        Cell cell = this.sheet.getRow(row).createCell(column);
        cell.setCellValue(value);
    }

    private Cell getCell(int row, int column) {
        return this.sheet.getRow(row).createCell(column);
    }
}

