/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.project;

import org.assertj.core.api.Assertions;
import org.drools.decisiontable.project.Person;
import org.drools.decisiontable.project.Result;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.KieResources;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class MultiSheetsTest {
    private KieSession ksession;

    @AfterEach
    public void tearDown() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
    }

    @Test
    public void testNoSheet() {
        this.check(null, "Mario can drink");
    }

    @Test
    public void testSheet1() {
        this.check("Sheet1", "Mario can drink");
    }

    @Test
    public void testSheet2() {
        this.check("Sheet2", "Mario can drive");
    }

    @Test
    public void testSheet12() {
        this.check("Sheet1,Sheet2", "Mario can drink", "Mario can drive");
    }

    private void check(String sheets, String ... expectedResults) {
        KieServices ks = KieServices.get();
        KieResources kr = ks.getResources();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/org/drools/simple/candrink/CanDrink.drl.xls", kr.newFileSystemResource("src/test/resources/data/CanDrinkAndDrive.drl.xls")).write("src/main/resources/org/drools/simple/candrink/CanDrink.drl.xls.properties", (String)(sheets != null ? "sheets=" + sheets : ""));
        KieModuleModel kproj = ks.newKieModuleModel();
        kproj.newKieBaseModel("dtblaleKB").addPackage("org.drools.simple.candrink").newKieSessionModel("dtable");
        kfs.writeKModuleXML(kproj.toXML());
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        KieContainer kc = ks.newKieContainer(kb.getKieModule().getReleaseId());
        this.ksession = kc.newKieSession("dtable");
        Result result = new Result();
        this.ksession.insert((Object)result);
        this.ksession.insert((Object)new Person("Mario", 45));
        this.ksession.fireAllRules();
        Assertions.assertThat((String)result.toString()).contains((CharSequence[])expectedResults);
    }
}

