/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.util.List;
import junit.framework.TestCase;
import org.drools.decisiontable.parser.csv.CsvLineParser;

public class CsvLineParserTest
extends TestCase {
    public void testSimpleLineParse() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,b,c";
        List list = parser.parse((CharSequence)"a,b,c");
        CsvLineParserTest.assertEquals((int)3, (int)list.size());
        CsvLineParserTest.assertEquals((String)"a", (String)((String)list.get(0)));
        CsvLineParserTest.assertEquals((String)"b", (String)((String)list.get(1)));
        CsvLineParserTest.assertEquals((String)"c", (String)((String)list.get(2)));
    }

    public void testLineParse() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,\"b\",c";
        List list = parser.parse((CharSequence)"a,\"b\",c");
        CsvLineParserTest.assertEquals((int)3, (int)list.size());
        CsvLineParserTest.assertEquals((String)"a", (String)((String)list.get(0)));
        CsvLineParserTest.assertEquals((String)"b", (String)((String)list.get(1)));
        CsvLineParserTest.assertEquals((String)"c", (String)((String)list.get(2)));
    }

    public void testDoubleQuotes() {
        CsvLineParser parser = new CsvLineParser();
        String s = "a,\"\"\"b\"\"\",c";
        List list = parser.parse((CharSequence)"a,\"\"\"b\"\"\",c");
        CsvLineParserTest.assertEquals((int)3, (int)list.size());
        CsvLineParserTest.assertEquals((String)"a", (String)((String)list.get(0)));
        CsvLineParserTest.assertEquals((String)"\"b\"", (String)((String)list.get(1)));
        CsvLineParserTest.assertEquals((String)"c", (String)((String)list.get(2)));
    }
}

