/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.util.Map;
import junit.framework.TestCase;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.format.CellFormat;
import org.drools.decisiontable.parser.xls.ExcelParser;

public class ExcelParserTest
extends TestCase {
    public void testRemoveTrailingZero() {
        String test = "1.0";
        ExcelParserTest.assertEquals((String)"1", (String)ExcelParser.removeTrailingZero((String)test));
        test = "42.0";
        ExcelParserTest.assertEquals((String)"42", (String)ExcelParser.removeTrailingZero((String)test));
        test = "42";
        ExcelParserTest.assertEquals((String)"42", (String)ExcelParser.removeTrailingZero((String)test));
    }

    public void testCellMerge() throws Exception {
        ExcelParser parser = new ExcelParser((Map)null);
        Range[] ranges = new Range[1];
        MockRange r1 = new MockRange();
        ranges[0] = r1;
        r1.topLeft = new MockCell();
        r1.topLeft.row = 2;
        r1.topLeft.column = 2;
        r1.topLeft.contents = "first";
        r1.bottomRight = new MockCell();
        r1.bottomRight.column = 5;
        r1.bottomRight.row = 7;
        r1.bottomRight.contents = "last";
        MockCell cell = new MockCell();
        cell.contents = "test";
        cell.row = 1;
        cell.column = 1;
        ExcelParserTest.assertNull((Object)parser.getRangeIfMerged((Cell)cell, ranges));
        cell = new MockCell();
        cell.contents = "wrong";
        cell.row = 2;
        cell.column = 5;
        ExcelParserTest.assertEquals((String)"first", (String)parser.getRangeIfMerged((Cell)cell, ranges).getTopLeft().getContents());
    }

    static class MockRange
    implements Range {
        MockCell bottomRight;
        MockCell topLeft;

        MockRange() {
        }

        public Cell getBottomRight() {
            return this.bottomRight;
        }

        public int getFirstSheetIndex() {
            return 0;
        }

        public int getLastSheetIndex() {
            return 0;
        }

        public Cell getTopLeft() {
            return this.topLeft;
        }
    }

    static class MockCell
    implements Cell {
        int column;
        int row;
        String contents;

        MockCell() {
        }

        public CellFormat getCellFormat() {
            return null;
        }

        public int getColumn() {
            return this.column;
        }

        public String getContents() {
            return this.contents;
        }

        public int getRow() {
            return this.row;
        }

        public CellType getType() {
            return null;
        }

        public boolean isHidden() {
            return false;
        }
    }
}

