/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.util.FileManager;

public class ChangeSetTest
extends TestCase {
    FileManager fileManager;

    protected void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
    }

    protected void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
    }

    public void testIntegregation() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", ((Object)((Object)this)).getClass()), ResourceType.CHANGE_SET);
        ChangeSetTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.fireAllRules();
        ksession.dispose();
        ChangeSetTest.assertEquals((int)3, (int)list.size());
        ChangeSetTest.assertEquals((Object)"Young man cheddar", list.get(0));
        ChangeSetTest.assertEquals((Object)"rule1", list.get(1));
        ChangeSetTest.assertEquals((Object)"rule2", list.get(2));
    }
}

