/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import junit.framework.TestCase;
import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Column;
import org.drools.template.parser.ColumnFactory;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.StringColumn;

public class ColumnFactoryTest
extends TestCase {
    public void testGetColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column");
        ColumnFactoryTest.assertTrue((boolean)(column instanceof StringColumn));
        ColumnFactoryTest.assertEquals((String)"column", (String)column.getName());
    }

    public void testGetStringArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: String[]");
        ColumnFactoryTest.assertTrue((boolean)(column instanceof ArrayColumn));
        ColumnFactoryTest.assertEquals((String)"column", (String)column.getName());
        ColumnFactoryTest.assertEquals((String)"StringCell", (String)((ArrayColumn)column).getCellType());
    }

    public void testGetLongArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: Long[]");
        ColumnFactoryTest.assertTrue((boolean)(column instanceof ArrayColumn));
        ColumnFactoryTest.assertEquals((String)"column", (String)column.getName());
        ColumnFactoryTest.assertEquals((String)"LongCell", (String)((ArrayColumn)column).getCellType());
    }

    public void testGetArrayColumnSimple() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column[]");
        ColumnFactoryTest.assertTrue((boolean)(column instanceof ArrayColumn));
        ColumnFactoryTest.assertEquals((String)"column", (String)column.getName());
        ColumnFactoryTest.assertEquals((String)"StringCell", (String)((ArrayColumn)column).getCellType());
    }

    public void testGetLongColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: Long");
        ColumnFactoryTest.assertTrue((boolean)(column instanceof LongColumn));
        ColumnFactoryTest.assertEquals((String)"column", (String)column.getName());
    }

    public void testInvalidGetColumn() {
        try {
            ColumnFactory f = new ColumnFactory();
            f.getColumn("column$");
            ColumnFactoryTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

