/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RulesheetUtil;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;

public class RuleWorksheetParseTest
extends TestCase {
    public void testBasicWorkbookProperties() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/BasicWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Properties props = listener.getProperties();
        RuleWorksheetParseTest.assertNotNull((Object)props);
        RuleWorksheetParseTest.assertEquals((String)"myruleset", (String)props.getProperty("RuleSet"));
        RuleWorksheetParseTest.assertEquals((String)"someMisc", (String)props.getProperty("misc"));
    }

    public void testComplexWorkbookProperties() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/ComplexWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Properties props = listener.getProperties();
        RuleWorksheetParseTest.assertNotNull((Object)props);
        String ruleSetName = props.getProperty("RuleSet");
        RuleWorksheetParseTest.assertEquals((String)"ruleSetName", (String)ruleSetName);
    }

    public void testWorkbookParse() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/BasicWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        RuleWorksheetParseTest.assertNotNull((Object)ruleset);
        Rule firstRule = (Rule)ruleset.getRules().get(0);
        RuleWorksheetParseTest.assertNotNull((Object)firstRule.getSalience());
        RuleWorksheetParseTest.assertTrue((firstRule.getSalience() > 0 ? 1 : 0) != 0);
        RuleWorksheetParseTest.assertEquals((String)"myruleset", (String)ruleset.getName());
        RuleWorksheetParseTest.assertEquals((int)2, (int)ruleset.getImports().size());
        RuleWorksheetParseTest.assertEquals((int)6, (int)ruleset.getRules().size());
        Import imp = (Import)ruleset.getImports().get(0);
        RuleWorksheetParseTest.assertEquals((String)"blah.class1", (String)imp.getClassName());
        imp = (Import)ruleset.getImports().get(1);
        RuleWorksheetParseTest.assertEquals((String)"blah.class2", (String)imp.getClassName());
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        RuleWorksheetParseTest.assertEquals((String)"Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")", (String)cond.getSnippet());
        Consequence cons = (Consequence)rule.getConsequences().get(0);
        RuleWorksheetParseTest.assertNotNull((Object)cons);
        RuleWorksheetParseTest.assertEquals((String)"myObject.setIsValid(Y);", (String)cons.getSnippet());
        rule = (Rule)ruleset.getRules().get(5);
        cond = (Condition)rule.getConditions().get(1);
        RuleWorksheetParseTest.assertEquals((String)"myObject.size () > 7", (String)cond.getSnippet());
        cons = (Consequence)rule.getConsequences().get(0);
        RuleWorksheetParseTest.assertEquals((String)"myObject.setIsValid(10-Jul-1974)", (String)cons.getSnippet());
    }

    public static RuleSheetListener getRuleSheetListener(InputStream stream) throws IOException {
        return RulesheetUtil.getRuleSheetListener(stream);
    }
}

