/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.core.util.FileManager;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeSetTest {
    FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
    }

    @Test
    public void testIntegregation() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Young man cheddar", list.get(0));
        Assert.assertEquals((Object)"rule1", list.get(1));
        Assert.assertEquals((Object)"rule2", list.get(2));
    }
}

