/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.Person;
import org.drools.rule.Package;
import org.drools.template.parser.TemplateDataListener;
import org.junit.Assert;
import org.junit.Test;

public class ExternalSpreadsheetCompilerIntegrationTest {
    @Test
    public void testIntegration() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/IntegrationExampleTest.xls", "/templates/test_integration.drl", 18, 3);
        System.out.println(drl);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        Package pkg = builder.getPackage();
        Assert.assertNotNull((Object)pkg);
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(pkg);
        StatefulSession wm = rb.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 42));
        wm.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testPricing() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        ArrayList<TemplateDataListener> listeners = new ArrayList<TemplateDataListener>();
        TemplateDataListener l1 = new TemplateDataListener(10, 3, "/templates/test_pricing1.drl");
        listeners.add(l1);
        TemplateDataListener l2 = new TemplateDataListener(30, 3, "/templates/test_pricing2.drl");
        listeners.add(l2);
        converter.compile("/data/ExamplePolicyPricing.xls", InputType.XLS, listeners);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(l1.renderDRL()));
        builder.addPackageFromDrl((Reader)new StringReader(l2.renderDRL()));
        Package pkg = builder.getPackage();
        Assert.assertNotNull((Object)pkg);
        DroolsError[] errors = builder.getErrors().getErrors();
        Assert.assertEquals((long)0L, (long)errors.length);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(pkg);
        StatefulSession wm = rb.newStatefulSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        wm.insert((Object)driver);
        wm.insert((Object)policy);
        wm.fireAllRules();
        System.out.println("BASE PRICE IS: " + policy.getBasePrice());
        System.out.println("DISCOUNT IS: " + policy.getDiscountPercent());
        int basePrice = policy.getBasePrice();
        Assert.assertEquals((long)120L, (long)basePrice);
    }
}

