/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.decisiontable.parser.RuleMatrixSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.junit.Assert;
import org.junit.Test;

public class SpreadsheetCompilerUnitTest {
    @Test
    public void testLoadFromClassPath() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", InputType.XLS);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool am I_12\"") > drl.indexOf("rule \"How cool am I_11\"") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package ") > -1 ? 1 : 0) != 0);
        InputStream ins = this.getClass().getResourceAsStream("/data/MultiSheetDST.xls");
        drl = converter.compile(false, ins, InputType.XLS);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool am I_12\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package ") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadSpecificWorksheet() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/MultiSheetDST.xls");
        String drl = converter.compile(stream, "Another Sheet");
        Assert.assertNotNull((Object)drl);
    }

    @Test
    public void testLoadCustomListener() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CustomWorkbook.xls");
        String drl = converter.compile(stream, InputType.XLS, (RuleSheetListener)new RuleMatrixSheetListener());
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("\"matrix\"") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("$v : FundVisibility") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("FundType") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Role") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCsv() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/ComplexWorkbook.csv");
        String drl = converter.compile(stream, InputType.CSV);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size () > 50") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assert.assertNotNull((Object)drl);
        System.out.println(drl);
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(10-Jul-1974)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar() eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar() eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") < drl.indexOf("b: Bar() eval(myObject.size() < 3)") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(\"19-Jul-1992\")") > -1 ? 1 : 0) != 0);
    }
}

