/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.junit.Assert;
import org.junit.Test;

public class ExternalSpreadsheetCompilerUnitTest {
    @Test
    public void testLoadFromClassPath() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", "/templates/test_template1.drl", 11, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool is Shaun 12\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rule \"How cool is Kumar 11\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadSpecificWorksheet() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", "Another Sheet", "/templates/test_template1.drl", 11, 2);
        Assert.assertNotNull((Object)drl);
    }

    @Test
    public void testLoadCsv() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/ComplexWorkbook.csv", "/templates/test_template2.drl", InputType.CSV, 10, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size () > 2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red),\n        myObject.size () > 1") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/BasicWorkbook.xls", "/templates/test_template3.drl", InputType.XLS, 10, 2);
        String drl1 = converter.compile("/data/BasicWorkbook.xls", "/templates/test_template3.drl", InputType.XLS, 21, 2);
        Assert.assertNotNull((Object)drl);
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("myObject.setIsValid(10-Jul-1974)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 12\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithExtraCells() {
        ExternalSpreadsheetCompiler compiler = new ExternalSpreadsheetCompiler();
        String drl = compiler.compile("/data/BasicWorkbook.xls", "/templates/test_template4.drl", InputType.XLS, 10, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 12\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0);
    }
}

