/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.agent.impl.FailureDetectingSystemEventListener;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.core.util.FileManager;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeSetTest {
    FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        ResourceChangeScannerConfiguration config = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        config.setProperty("drools.resource.scanner.interval", "1");
        ResourceFactory.getResourceChangeScannerService().configure(config);
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
    }

    @Test
    public void testIntegration() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Young man cheddar", list.get(0));
        Assert.assertEquals((Object)"rule1", list.get(1));
        Assert.assertEquals((Object)"rule2", list.get(2));
    }

    @Test
    public void multipleSheets() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"multipleSheetsChangeSet.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.insert((Object)new Person("Jane", "stilton", 55));
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Young man cheddar"));
        Assert.assertTrue((boolean)list.contains("Jane eats cheddar"));
    }

    @Test
    public void testCSV() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeSetTestCSV.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
    }

    @Test
    public void testCSVByKnowledgeAgent() {
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"csv agent");
        kagent.applyChangeSet(ResourceFactory.newClassPathResource((String)"changeSetTestCSV.xml", this.getClass()));
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVByKnowledgeAgentWithFileReader() throws IOException {
        FailureDetectingSystemEventListener systemEventListener = new FailureDetectingSystemEventListener();
        SystemEventListenerFactory.setSystemEventListener((SystemEventListener)systemEventListener);
        try {
            File targetTestFilesDir = new File("target/testFiles");
            targetTestFilesDir.mkdirs();
            File changeSetFile = new File(targetTestFilesDir, "changeSetTestCSV.xml");
            FileUtils.copyURLToFile((URL)this.getClass().getResource("changeSetTestCSV.xml"), (File)changeSetFile);
            KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"csv agent");
            kagent.setSystemEventListener((SystemEventListener)systemEventListener);
            kagent.applyChangeSet(ResourceFactory.newFileResource((File)changeSetFile));
            KnowledgeBase kbase = kagent.getKnowledgeBase();
            Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
            Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
            if (!systemEventListener.isSuccessful()) {
                for (Throwable throwable : systemEventListener.getExceptionList()) {
                    throwable.printStackTrace();
                }
                Assert.fail((String)"The scanner ran into exceptions");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }
}

