/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import org.drools.KnowledgeBase;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.agent.impl.PrintStreamSystemEventListener;
import org.drools.core.util.FileManager;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScannerChangeSetTest {
    public static final String TMP_DIR = "target/classes/";
    FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCSVByResourceChangeScanner() throws InterruptedException, IOException {
        String first = this.fileManager.readInputStreamReaderAsString(new InputStreamReader(this.getClass().getResourceAsStream("changeSetTestCSV.csv")));
        String second = this.fileManager.readInputStreamReaderAsString(new InputStreamReader(this.getClass().getResourceAsStream("changeSetTestCSV2.csv")));
        File file = new File("target/classes/scannerChangeSetTestCSV.csv");
        file.delete();
        this.fileManager.write(file, first);
        Thread.sleep(1100L);
        ResourceChangeScannerConfiguration config = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        config.setProperty("drools.resource.scanner.interval", "1");
        ResourceFactory.getResourceChangeScannerService().configure(config);
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"csv agent");
        kagent.applyChangeSet(ResourceFactory.newClassPathResource((String)"scannerChangeSetTestCSV.xml", this.getClass()));
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)3L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        Thread.sleep(1100L);
        file.delete();
        this.fileManager.write(file, second);
        Thread.sleep(1100L);
        try {
            kbase = kagent.getKnowledgeBase();
            Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
            Assert.assertEquals((long)2L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        }
        finally {
            ResourceFactory.getResourceChangeNotifierService().stop();
            ResourceFactory.getResourceChangeScannerService().stop();
            file.delete();
            kagent.dispose();
        }
    }

    @Test
    public void testXLSByResourceChangeScanner() throws Exception {
        SystemEventListenerFactory.setSystemEventListener((SystemEventListener)new PrintStreamSystemEventListener(System.out));
        File ruleFile = new File("target/classes/sample.xls");
        ScannerChangeSetTest.copy(this.getClass().getResourceAsStream("sample.xls"), new FileOutputStream(ruleFile));
        String XLS_CHANGESET = "<change-set xmlns=\"http://drools.org/drools-5.0/change-set\"\n            xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n            xs:schemaLocation=\"http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd\">\n  <add>\n    <resource source=\"file:" + ruleFile.getAbsolutePath() + "\" type=\"DTABLE\">\n" + "      <decisiontable-conf input-type=\"XLS\" worksheet-name=\"Tables\"/>\n" + "    </resource>" + "  </add>\n" + "</change-set>\n";
        File xlsChangeset = new File("target/classes/xlsChangeset.xml");
        xlsChangeset.deleteOnExit();
        ScannerChangeSetTest.writeToFile(xlsChangeset, XLS_CHANGESET);
        ResourceChangeScannerConfiguration config = ResourceFactory.getResourceChangeScannerService().newResourceChangeScannerConfiguration();
        config.setProperty("drools.resource.scanner.interval", "1");
        ResourceFactory.getResourceChangeScannerService().configure(config);
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)"xls agent");
        kagent.applyChangeSet(ResourceFactory.newFileResource((File)xlsChangeset));
        KnowledgeBase kbase = kagent.getKnowledgeBase();
        ResourceFactory.getResourceChangeNotifierService().start();
        ResourceFactory.getResourceChangeScannerService().start();
        Assert.assertEquals((long)2L, (long)kbase.getKnowledgePackages().size());
        Assert.assertEquals((long)3L, (long)kbase.getKnowledgePackage("com.sample").getRules().size());
        Thread.sleep(1500L);
        ruleFile.delete();
        ruleFile = new File("target/classes/sample.xls");
        ScannerChangeSetTest.copy(this.getClass().getResourceAsStream("sample2.xls"), new FileOutputStream(ruleFile));
        Thread.sleep(1000L);
        Assert.assertEquals((long)kbase.getKnowledgePackages().size(), (long)2L);
        Assert.assertEquals((long)3L, (long)kbase.getKnowledgePackage("com.sample").getRules().size());
        kbase = kagent.getKnowledgeBase();
        Assert.assertEquals((long)kbase.getKnowledgePackages().size(), (long)2L);
        Assert.assertEquals((long)2L, (long)kbase.getKnowledgePackage("com.sample").getRules().size());
        ResourceFactory.getResourceChangeNotifierService().stop();
        ResourceFactory.getResourceChangeScannerService().stop();
        kagent.dispose();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, String content) throws Exception {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(content);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public class Message
    implements Serializable {
        private static final long serialVersionUID = -7176392345381065685L;
        private String message;

        public Message() {
            this.message = "";
        }

        public Message(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return "org.jboss.qa.drools.domain.Message[message='" + this.message + "']";
        }
    }

    public static class Person {
        private int id;

        public void setId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

