/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import org.acme.insurance.launcher.PricingRuleLauncher;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.KieServices;
import org.kie.builder.DecisionTableConfiguration;
import org.kie.builder.DecisionTableInputType;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.Resource;
import org.kie.io.ResourceConfiguration;
import org.kie.io.ResourceFactory;
import org.kie.runtime.KieSession;

public class SpreadsheetIntegrationExampleTest {
    @Test
    public void testExecuteUsingKieAPI() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", this.getClass());
        KieSession ksession = this.getKieSession(dt);
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Old man stilton", list.get(0));
    }

    private KieSession getKieSession(Resource dt) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write(dt);
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertTrue((boolean)kb.getResults().getMessages().isEmpty());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        return ksession;
    }

    @Test
    public void testExecuteJBRULES3005() throws Exception {
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", this.getClass());
        KieSession ksession = this.getKieSession(dt);
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Old man stilton", list.get(0));
    }

    @Test
    public void testNamedWorksheet() throws Exception {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        dtconf.setWorksheetName("Tables_2");
        Resource dt = ResourceFactory.newClassPathResource((String)"/data/IntegrationExampleTest.xls", this.getClass()).setConfiguration((ResourceConfiguration)dtconf);
        KieSession ksession = this.getKieSession(dt);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Young man cheddar", list.get(0));
    }

    @Test
    public void testInsuranceExample() throws Exception {
        PricingRuleLauncher launcher = new PricingRuleLauncher();
        Assert.assertEquals((long)120L, (long)launcher.executeExample());
    }
}

