/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.drools.compiler.DecisionTableFactory;
import org.drools.rule.Rule;
import org.junit.Assert;
import org.junit.Test;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.DecisionTableConfiguration;
import org.kie.builder.DecisionTableInputType;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.ResourceConfiguration;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;

public class ColumnReplaceTest {
    @Test
    public void testAutoFocusToLockOnActiveReplacement() throws FileNotFoundException {
        DecisionTableConfiguration dTableConfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dTableConfiguration.setInputType(DecisionTableInputType.CSV);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"columnReplaceTest.csv", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dTableConfiguration);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.fail((String)"Knowledge builder cannot compile package!");
        }
        System.out.println(DecisionTableFactory.loadFromInputStream((InputStream)new FileInputStream(new File("src/test/resources/org/drools/decisiontable/columnReplaceTest.csv")), (DecisionTableConfiguration)dTableConfiguration));
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Assert.assertTrue((boolean)((Rule)kbase.getRule("org.drools.decisiontable", "lockOnActiveRule")).isLockOnActive());
        Assert.assertFalse((boolean)((Rule)kbase.getRule("org.drools.decisiontable", "autoFocusRule")).isLockOnActive());
        Assert.assertFalse((boolean)((Rule)kbase.getRule("org.drools.decisiontable", "lockOnActiveRule")).getAutoFocus());
        Assert.assertTrue((boolean)((Rule)kbase.getRule("org.drools.decisiontable", "autoFocusRule")).getAutoFocus());
    }
}

