/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RhsBuilder;
import org.junit.Assert;
import org.junit.Test;

public class RhsBuilderTest {
    @Test
    public void testConsBuilding() {
        RhsBuilder builder = new RhsBuilder(ActionType.Code.ACTION, 9, 1, "foo");
        builder.addTemplate(10, 1, "setFoo($param)");
        builder.addCellValue(10, 1, "42");
        Assert.assertEquals((Object)"foo.setFoo(42);", (Object)builder.getResult());
        builder.clearValues();
        builder.addCellValue(10, 1, "33");
        Assert.assertEquals((Object)"foo.setFoo(33);", (Object)builder.getResult());
    }

    @Test
    public void testClassicMode() {
        RhsBuilder builder = new RhsBuilder(ActionType.Code.ACTION, 9, 1, "");
        builder.addTemplate(10, 1, "p.setSomething($param);");
        builder.addTemplate(10, 2, "drools.clearAgenda();");
        builder.addCellValue(12, 1, "42");
        Assert.assertEquals((Object)"p.setSomething(42);", (Object)builder.getResult());
        builder.addCellValue(12, 2, "Y");
        Assert.assertEquals((Object)"p.setSomething(42);\ndrools.clearAgenda();", (Object)builder.getResult());
    }

    @Test
    public void testMetadata() {
        RhsBuilder builder = new RhsBuilder(ActionType.Code.METADATA, 9, 1, "");
        builder.addTemplate(10, 1, "Author($param)");
        builder.addCellValue(12, 1, "A. U. Thor");
        Assert.assertEquals((Object)"Author(A. U. Thor)", (Object)builder.getResult());
        builder.clearValues();
        builder.addCellValue(13, 1, "P. G. Wodehouse");
        Assert.assertEquals((Object)"Author(P. G. Wodehouse)", (Object)builder.getResult());
    }

    @Test
    public void testEmptyCellData() {
        RhsBuilder builder = new RhsBuilder(ActionType.Code.ACTION, 9, 1, "Foo");
        builder.addTemplate(10, 1, "p.setSomething($param);");
        Assert.assertFalse((boolean)builder.hasValues());
    }
}

