/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleMatrixSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SpreadsheetCompilerUnitTest {
    @Test
    public void testLoadFromClassPath() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", InputType.XLS);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool am I_12\"") > drl.indexOf("rule \"How cool am I_11\"") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package ") > -1 ? 1 : 0) != 0);
        InputStream ins = this.getClass().getResourceAsStream("/data/MultiSheetDST.xls");
        drl = converter.compile(false, ins, InputType.XLS);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool am I_12\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("package ") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadSpecificWorksheet() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/MultiSheetDST.xls");
        String drl = converter.compile(stream, "Another Sheet");
        Assert.assertNotNull((Object)drl);
    }

    @Test
    public void testLoadCustomListener() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/CustomWorkbook.xls");
        String drl = converter.compile(stream, InputType.XLS, (RuleSheetListener)new RuleMatrixSheetListener());
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("\"matrix\"") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("$v : FundVisibility") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("FundType") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Role") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadCsv() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/ComplexWorkbook.csv");
        String drl = converter.compile(stream, InputType.CSV);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size () > 50") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assert.assertNotNull((Object)drl);
        System.out.println(drl);
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(10-Jul-1974)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar() eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar() eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size () > 1)") < drl.indexOf("b: Bar() eval(myObject.size() < 3)") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(\"19-Jul-1992\")") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDeclaresXLS() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("DeclaresWorkbook.xls", InputType.XLS);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("declare Smurf name : String end") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDeclaresCSV() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("DeclaresWorkbook.csv", InputType.CSV);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("declare Smurf name : String end") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAttributesXLS() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("Attributes.xls", InputType.XLS);
        Assert.assertNotNull((Object)drl);
        int rule1 = drl.indexOf("rule \"N1\"");
        Assert.assertFalse((rule1 == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("no-loop true", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("duration 100", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 1", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("ruleflow-group \"RFG1\"", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("agenda-group \"AG1\"", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("timer (T1)", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("lock-on-active true", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("activation-group \"g1\"", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("auto-focus true", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("calendars \"CAL1\"", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("date-effective \"01-Jan-2007\"", rule1) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("date-expires \"31-Dec-2007\"", rule1) > -1 ? 1 : 0) != 0);
        int rule2 = drl.indexOf("rule \"N2\"");
        Assert.assertFalse((rule2 == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("no-loop false", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("duration 200", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 2", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("ruleflow-group \"RFG2\"", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("agenda-group \"AG2\"", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("timer (T2)", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("lock-on-active false", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("activation-group \"g2\"", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("auto-focus false", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("calendars \"CAL2\"", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("date-effective \"01-Jan-2012\"", rule2) > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("date-expires \"31-Dec-2015\"", rule2) > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testPropertiesXLS() {
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("Properties.xls");
        parser.parseFile(is);
        listener.getProperties();
        String rulesetName = listener.getProperties().getSingleProperty("RuleSet");
        Assert.assertNotNull((Object)rulesetName);
        Assert.assertEquals((Object)"Properties", (Object)rulesetName);
        List importList = RuleSheetParserUtil.getImportList((List)listener.getProperties().getProperty("Import"));
        Assert.assertNotNull((Object)importList);
        Assert.assertEquals((long)1L, (long)importList.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Import)importList.get(0)).getClassName());
        List variableList = RuleSheetParserUtil.getVariableList((List)listener.getProperties().getProperty("Variables"));
        Assert.assertNotNull((Object)variableList);
        Assert.assertEquals((long)1L, (long)variableList.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Global)variableList.get(0)).getClassName());
        Assert.assertEquals((Object)"list", (Object)((Global)variableList.get(0)).getIdentifier());
        List functions = listener.getProperties().getProperty("Functions");
        Assert.assertNotNull((Object)functions);
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertEquals((Object)"A function", functions.get(0));
        List queries = listener.getProperties().getProperty("Queries");
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        Assert.assertEquals((Object)"A query", queries.get(0));
        List declarations = listener.getProperties().getProperty("Declare");
        Assert.assertNotNull((Object)declarations);
        Assert.assertEquals((long)1L, (long)declarations.size());
        Assert.assertEquals((Object)"A declared type", declarations.get(0));
        String sequentialFlag = listener.getProperties().getSingleProperty("Sequential");
        Assert.assertNotNull((Object)sequentialFlag);
        Assert.assertEquals((Object)"false", (Object)sequentialFlag);
        String escapeQuotesFlag = listener.getProperties().getSingleProperty("EscapeQuotes");
        Assert.assertNotNull((Object)escapeQuotesFlag);
        Assert.assertEquals((Object)"false", (Object)escapeQuotesFlag);
    }

    @Test
    public void testPropertiesWithWhiteSpaceXLS() {
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listeners.add(listener);
        ExcelParser parser = new ExcelParser(listeners);
        InputStream is = this.getClass().getResourceAsStream("PropertiesWithWhiteSpace.xls");
        parser.parseFile(is);
        listener.getProperties();
        String rulesetName = listener.getProperties().getSingleProperty("RuleSet");
        Assert.assertNotNull((Object)rulesetName);
        Assert.assertEquals((Object)"Properties", (Object)rulesetName);
        List importList = RuleSheetParserUtil.getImportList((List)listener.getProperties().getProperty("Import"));
        Assert.assertNotNull((Object)importList);
        Assert.assertEquals((long)1L, (long)importList.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Import)importList.get(0)).getClassName());
        List variableList = RuleSheetParserUtil.getVariableList((List)listener.getProperties().getProperty("Variables"));
        Assert.assertNotNull((Object)variableList);
        Assert.assertEquals((long)1L, (long)variableList.size());
        Assert.assertEquals((Object)"java.util.List", (Object)((Global)variableList.get(0)).getClassName());
        Assert.assertEquals((Object)"list", (Object)((Global)variableList.get(0)).getIdentifier());
        List functions = listener.getProperties().getProperty("Functions");
        Assert.assertNotNull((Object)functions);
        Assert.assertEquals((long)1L, (long)functions.size());
        Assert.assertEquals((Object)"A function", functions.get(0));
        List queries = listener.getProperties().getProperty("Queries");
        Assert.assertNotNull((Object)queries);
        Assert.assertEquals((long)1L, (long)queries.size());
        Assert.assertEquals((Object)"A query", queries.get(0));
        List declarations = listener.getProperties().getProperty("Declare");
        Assert.assertNotNull((Object)declarations);
        Assert.assertEquals((long)1L, (long)declarations.size());
        Assert.assertEquals((Object)"A declared type", declarations.get(0));
        String sequentialFlag = listener.getProperties().getSingleProperty("Sequential");
        Assert.assertNotNull((Object)sequentialFlag);
        Assert.assertEquals((Object)"false", (Object)sequentialFlag);
        String escapeQuotesFlag = listener.getProperties().getSingleProperty("EscapeQuotes");
        Assert.assertNotNull((Object)escapeQuotesFlag);
        Assert.assertEquals((Object)"false", (Object)escapeQuotesFlag);
    }

    @Test
    public void testProcessSheetForExtremeLowNumbers() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        InputStream stream = this.getClass().getResourceAsStream("/data/BasicWorkbook_with_low_values.xls");
        String drl = converter.compile(stream, InputType.XLS);
        Assert.assertNotNull((Object)drl);
        System.out.println(drl);
        Assert.assertTrue((drl.indexOf("myObject.size() < 0") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size() < 8.0E-11") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size() < 9.0E-7") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size() < 3.0E-4") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeNumbers() throws Exception {
        KnowledgeBase kbase = this.readKnowledgeBase("/data/DT_WithNegativeNumbers.xls");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        IntHolder i1 = new IntHolder(1);
        IntHolder i2 = new IntHolder(-1);
        ksession.insert((Object)i1);
        ksession.insert((Object)i2);
        ksession.fireAllRules();
    }

    @Test
    public void testOOXMLParseCellValue() {
        SpreadsheetCompiler converter = new SpreadsheetCompiler();
        String drl = converter.compile("/data/BZ963584.xls", InputType.XLS);
        Assert.assertNotNull((Object)drl);
    }

    private KnowledgeBase readKnowledgeBase(String resource) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        DecisionTableConfiguration config = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        config.setInputType(DecisionTableInputType.XLS);
        kbuilder.add(ResourceFactory.newClassPathResource((String)resource, this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)config);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    public static class IntHolder {
        private int value;

        public IntHolder(int i) {
            this.value = i;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "IntHolder [value=" + this.value + "]";
        }
    }
}

