/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.rule.Package;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.Person;
import org.drools.template.parser.TemplateDataListener;
import org.junit.Assert;
import org.junit.Test;

public class ExternalSpreadsheetCompilerTest {
    @Test
    public void testLoadFromClassPath() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", "/templates/test_template1.drl", 11, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool is Shaun 12\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rule \"How cool is Kumar 11\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadSpecificWorksheet() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", "Another Sheet", "/templates/test_template1.drl", 11, 2);
        Assert.assertNotNull((Object)drl);
    }

    @Test
    public void testLoadCsv() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/ComplexWorkbook.csv", "/templates/test_template2.drl", InputType.CSV, 10, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size () > 2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red),\n        myObject.size () > 1") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/BasicWorkbook.xls", "/templates/test_template3.drl", InputType.XLS, 10, 2);
        String drl1 = converter.compile("/data/BasicWorkbook.xls", "/templates/test_template3.drl", InputType.XLS, 21, 2);
        Assert.assertNotNull((Object)drl);
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("myObject.setIsValid(10-Jul-1974)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 12\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithExtraCells() {
        ExternalSpreadsheetCompiler compiler = new ExternalSpreadsheetCompiler();
        String drl = compiler.compile("/data/BasicWorkbook.xls", "/templates/test_template4.drl", InputType.XLS, 10, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 12\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0);
    }

    @Test
    public void testIntegration() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/IntegrationExampleTest.xls", "/templates/test_integration.drl", 18, 3);
        System.out.println(drl);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        Package pkg = builder.getPackage();
        Assert.assertNotNull((Object)pkg);
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(pkg);
        StatefulSession wm = rb.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 42));
        wm.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testPricing() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        ArrayList<TemplateDataListener> listeners = new ArrayList<TemplateDataListener>();
        TemplateDataListener l1 = new TemplateDataListener(10, 3, "/templates/test_pricing1.drl");
        listeners.add(l1);
        TemplateDataListener l2 = new TemplateDataListener(30, 3, "/templates/test_pricing2.drl");
        listeners.add(l2);
        converter.compile("/data/ExamplePolicyPricing.xls", InputType.XLS, listeners);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(l1.renderDRL()));
        builder.addPackageFromDrl((Reader)new StringReader(l2.renderDRL()));
        Package pkg = builder.getPackage();
        Assert.assertNotNull((Object)pkg);
        DroolsError[] errors = builder.getErrors().getErrors();
        Assert.assertEquals((long)0L, (long)errors.length);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(pkg);
        StatefulSession wm = rb.newStatefulSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        wm.insert((Object)driver);
        wm.insert((Object)policy);
        wm.fireAllRules();
        System.out.println("BASE PRICE IS: " + policy.getBasePrice());
        System.out.println("DISCOUNT IS: " + policy.getDiscountPercent());
        int basePrice = policy.getBasePrice();
        Assert.assertEquals((long)120L, (long)basePrice);
    }
}

