/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.integrationtests;

import java.io.InputStream;
import junit.framework.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;

public class IncrementalCompilationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateXLSResources() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        InputStream in1 = null;
        InputStream in2 = null;
        try {
            in1 = this.getClass().getResourceAsStream("incrementalBuild.dtable.xls");
            kfs.write("src/main/resources/incrementalBuild1.dtable.xls", KieServices.Factory.get().getResources().newInputStreamResource(in1));
            in2 = this.getClass().getResourceAsStream("incrementalBuild.dtable.xls");
            kfs.write("src/main/resources/incrementalBuild2.dtable.xls", KieServices.Factory.get().getResources().newInputStreamResource(in2));
            Assert.assertEquals((int)1, (int)ks.newKieBuilder(kfs).buildAll().getResults().getMessages().size());
        }
        finally {
            if (in1 != null) {
                in1.close();
            }
            if (in2 != null) {
                in2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementalCompilationDuplicateXLSResources() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        InputStream in1 = null;
        InputStream in2 = null;
        try {
            in1 = this.getClass().getResourceAsStream("incrementalBuild.dtable.xls");
            kfs.write("src/main/resources/incrementalBuild1.dtable.xls", KieServices.Factory.get().getResources().newInputStreamResource(in1));
            KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
            Assert.assertEquals((int)0, (int)kieBuilder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).size());
            in2 = this.getClass().getResourceAsStream("incrementalBuild.dtable.xls");
            kfs.write("src/main/resources/incrementalBuild2.dtable.xls", KieServices.Factory.get().getResources().newInputStreamResource(in2));
            IncrementalResults addResults = ((InternalKieBuilder)kieBuilder).createFileSet(new String[]{"src/main/resources/incrementalBuild2.dtable.xls"}).build();
            Assert.assertEquals((int)1, (int)addResults.getAddedMessages().size());
            Assert.assertEquals((int)0, (int)addResults.getRemovedMessages().size());
            Assert.assertEquals((int)1, (int)ks.newKieBuilder(kfs).buildAll().getResults().getMessages().size());
        }
        finally {
            if (in1 != null) {
                in1.close();
            }
            if (in2 != null) {
                in2.close();
            }
        }
    }
}

