/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.List;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RuleSheetParserUtilTest {
    @Test
    public void testRuleName() {
        String row = "  RuleTable       This is my rule name";
        String result = RuleSheetParserUtil.getRuleName((String)"  RuleTable       This is my rule name");
        Assert.assertEquals((Object)"This is my rule name", (Object)result);
    }

    @Ignore
    @Test
    public void testInvalidRuleName() {
        String row = "RuleTable       This is my rule name (type class)";
        try {
            String result = RuleSheetParserUtil.getRuleName((String)"RuleTable       This is my rule name (type class)");
            Assert.fail((String)("should have failed, but get result: " + result));
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testIsStringMeaningTrue() {
        Assert.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"true"));
        Assert.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"TRUE"));
        Assert.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"yes"));
        Assert.assertTrue((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"oN"));
        Assert.assertFalse((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"no"));
        Assert.assertFalse((boolean)RuleSheetParserUtil.isStringMeaningTrue((String)"false"));
        Assert.assertFalse((boolean)RuleSheetParserUtil.isStringMeaningTrue(null));
    }

    @Test
    public void testListImports() {
        ArrayList<String> cellVals = null;
        List list = RuleSheetParserUtil.getImportList(cellVals);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)0L, (long)list.size());
        cellVals = new ArrayList<String>();
        cellVals.add("");
        Assert.assertEquals((long)0L, (long)RuleSheetParserUtil.getImportList(cellVals).size());
        cellVals.add(0, "com.something.Yeah, com.something.No,com.something.yeah.*");
        list = RuleSheetParserUtil.getImportList(cellVals);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"com.something.Yeah", (Object)((Import)list.get(0)).getClassName());
        Assert.assertEquals((Object)"com.something.No", (Object)((Import)list.get(1)).getClassName());
        Assert.assertEquals((Object)"com.something.yeah.*", (Object)((Import)list.get(2)).getClassName());
    }

    @Test
    public void testListVariables() {
        ArrayList<String> varCells = new ArrayList<String>();
        varCells.add("Var1 var1, Var2 var2,Var3 var3");
        List varList = RuleSheetParserUtil.getVariableList(varCells);
        Assert.assertNotNull((Object)varList);
        Assert.assertEquals((long)3L, (long)varList.size());
        Global var = (Global)varList.get(0);
        Assert.assertEquals((Object)"Var1", (Object)var.getClassName());
        var = (Global)varList.get(2);
        Assert.assertEquals((Object)"Var3", (Object)var.getClassName());
        Assert.assertEquals((Object)"var3", (Object)var.getIdentifier());
    }

    @Test
    public void testBadVariableFormat() {
        ArrayList<String> varCells = new ArrayList<String>();
        varCells.add("class1, object2");
        try {
            RuleSheetParserUtil.getVariableList(varCells);
            Assert.fail((String)"should not work");
        }
        catch (DecisionTableParseException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testRowColumnToCellNAme() {
        String cellName = RuleSheetParserUtil.rc2name((int)0, (int)0);
        Assert.assertEquals((Object)"A1", (Object)cellName);
        cellName = RuleSheetParserUtil.rc2name((int)0, (int)10);
        Assert.assertEquals((Object)"K1", (Object)cellName);
        cellName = RuleSheetParserUtil.rc2name((int)0, (int)42);
        Assert.assertEquals((Object)"AQ1", (Object)cellName);
        cellName = RuleSheetParserUtil.rc2name((int)9, (int)27);
        Assert.assertEquals((Object)"AB10", (Object)cellName);
        cellName = RuleSheetParserUtil.rc2name((int)99, (int)53);
        Assert.assertEquals((Object)"BB100", (Object)cellName);
    }
}

