/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.integrationtests;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;

public class KModuleWithDecisionTablesTest {
    @Test
    public void testNonEmptyKieBaseWithXLS() throws Exception {
        this.testNonEmptyKieBase("kbaseXLS");
    }

    @Test
    public void testNonEmptyKieBaseWithCSV() throws Exception {
        this.testNonEmptyKieBase("kbaseCSV");
    }

    @Test
    public void testNonEmptyKieBaseWithWrongCSV() throws Exception {
        String csv = "\"RuleSet\",\"org.jboss.qa.brms.bre.functional.expert.decisiontable\",,,\n\"Import\",\"org.jboss.qa.brms.domain.Message\",,,\n,,,,\n\"RuleTable TimerCalendarRule\",,,,\n\"NAME\",\"TIMER\",\"CALENDARS\",\"ACTION\",\"Description\"\n,,,,\n,,,\"insert(new Message(\\\"$param\\\"));\",\n\"Rule name\",\"Timer value\",\"Calendar value\",\"Inserted message text\",\"Note\"\n\"Weekend rule\",,\"weekend\",\"Weekend rule\",\n\"Every 100 ms weekday rule\",\"int: 0 100ms\",\"weekday\",\"Every 100 ms weekday rule\",\n\"Delayed Tuesday rule\",\"int: 1000 0\",\"tuesday\",\"Delayed Tuesday rule\",\n\"Delayed repetitive Friday rule\",\"int: 500ms 1s\",\"friday\",\"Delayed repetitive Friday rule\",\n\"Delayed rule\",\"int: 1s 0ms\",,\"Delayed rule\",\n\"Repetitive rule\",\"int: 0ms 100\",,\"Repetitive rule\",\n\"Repetitive delayed rule\",\"int: 1s 100ms\",,\"Repetitive delayed rule\",\n\"Cron rule\",\"cron: */1 * * * * ?\",,\"Cron rule\",\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.csv", csv);
        Results results = ks.newKieBuilder(kfs).buildAll().getResults();
        Assert.assertFalse((boolean)results.getMessages().isEmpty());
    }

    private void testNonEmptyKieBase(String kieBaseName) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieContainer kContainer = ks.getKieClasspathContainer();
        KieBase kieBase = kContainer.getKieBase(kieBaseName);
        Assert.assertNotNull((String)"KieBase not found", (Object)kieBase);
        Assert.assertEquals((String)"Unexpected number of KiePackages in KieBase", (long)1L, (long)kieBase.getKiePackages().size());
    }
}

