/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.RulesheetUtil;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class RuleWorksheetParseTest {
    private RuleSheetListener listener;
    private int row;

    @Test
    public void testBasicWorkbookProperties() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/BasicWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        PropertiesSheetListener.CaseInsensitiveMap props = listener.getProperties();
        Assert.assertNotNull((Object)props);
        Assert.assertEquals((Object)"myruleset", (Object)props.getSingleProperty("RuleSet"));
        Assert.assertEquals((Object)"someMisc", (Object)props.getSingleProperty("misc"));
    }

    @Test
    public void testComplexWorkbookProperties() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/ComplexWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        PropertiesSheetListener.CaseInsensitiveMap props = listener.getProperties();
        Assert.assertNotNull((Object)props);
        String ruleSetName = props.getSingleProperty("RuleSet");
        Assert.assertEquals((Object)"ruleSetName", (Object)ruleSetName);
    }

    @Test
    public void testWorkbookParse() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/BasicWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assert.assertNotNull((Object)ruleset);
        Rule firstRule = (Rule)ruleset.getRules().get(0);
        Assert.assertNotNull((Object)firstRule.getSalience());
        Assert.assertTrue((Integer.parseInt(firstRule.getSalience()) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"myruleset", (Object)ruleset.getName());
        Assert.assertEquals((long)3L, (long)ruleset.getImports().size());
        Assert.assertEquals((long)6L, (long)ruleset.getRules().size());
        Import imp = (Import)ruleset.getImports().get(0);
        Assert.assertEquals((Object)"blah.class1", (Object)imp.getClassName());
        imp = (Import)ruleset.getImports().get(1);
        Assert.assertEquals((Object)"blah.class2", (Object)imp.getClassName());
        imp = (Import)ruleset.getImports().get(2);
        Assert.assertEquals((Object)"lah.di.dah", (Object)imp.getClassName());
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assert.assertEquals((Object)"Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")", (Object)cond.getSnippet());
        Consequence cons = (Consequence)rule.getConsequences().get(0);
        Assert.assertNotNull((Object)cons);
        Assert.assertEquals((Object)"myObject.setIsValid(Y);", (Object)cons.getSnippet());
        rule = (Rule)ruleset.getRules().get(5);
        cond = (Condition)rule.getConditions().get(1);
        Assert.assertEquals((Object)"myObject.size () > 7", (Object)cond.getSnippet());
        cons = (Consequence)rule.getConsequences().get(0);
        Assert.assertEquals((Object)"myObject.setIsValid(10-Jul-1974)", (Object)cons.getSnippet());
    }

    private void makeRuleSet() {
        this.listener = new DefaultRuleSheetListener();
        this.listener.startSheet("bad_sheet");
        this.row = 1;
        this.listener.newRow(this.row, 2);
        this.listener.newCell(this.row, 1, "RuleSet", -1);
        this.listener.newCell(this.row, 2, "myRuleSet", -1);
    }

    private void makeAttribute(String key, String val) {
        ++this.row;
        this.listener.newRow(this.row, 2);
        this.listener.newCell(this.row, 1, key, -1);
        this.listener.newCell(this.row, 2, val, -1);
    }

    private void makeRuleTable() {
        this.listener.newRow(10, 1);
        this.listener.newCell(10, 1, "RuleTable myRuleTable", -1);
    }

    private void makeRow(int row, String ... values) throws DecisionTableParseException {
        this.listener.newRow(row, values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            this.listener.newCell(row, i + 1, values[i], -1);
        }
    }

    @Test
    public void testTooManyColumnsNoLoop() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "A", "U", "U");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)11, (int)5);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testTooManyColumnsPriority() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "A", "PRIORITY", "P");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)11, (int)5);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testBadColumnHeader() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "Condition", "CONDITION", "A", "SMURF", "P");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)11, (int)4);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testMissingCondition() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "C", "A", "A");
            this.makeRow(12, "attr == $param", "attr == $param", "attr == $param", "action();", "action();");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)12, (int)1);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testMissingCodeSnippetCondition() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "C", "A", "A");
            this.makeRow(12, "Foo", "Foo", "Foo");
            this.makeRow(13, "attr == $param", "attr == $param", "", "action();", "action();");
            this.makeRow(15, "1", "2", "3", "", "");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)3);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testSpuriousCodeSnippet() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "A");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "attr == $param", "action();", "attr > $param");
            this.makeRow(15, "1", "2", "");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)4);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testIncorrectPriority() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "A", "P");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "x");
            this.makeRow(15, "1", "show()", "12E");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)15, (int)3);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testSnippetForAttribute() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "A", "G");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "x", "XXX");
            this.makeRow(15, "1", "show()", "10");
            this.listener.finishSheet();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)3);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testRuleAttributeRendering() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "G");
        this.makeRow(12, "Foo", "Foo");
        this.makeRow(13, "attr == $param", "x");
        this.makeRow(15, "1", "show()", "foo bar");
        this.makeRow(16, "2", "list()", "\"10\" group\"");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assert.assertTrue((boolean)drl.contains("agenda-group \"foo bar\""));
        Assert.assertTrue((boolean)drl.contains("agenda-group \"10\\\" group\""));
    }

    @Test
    public void testDuplicatePackageAttribute() {
        try {
            this.makeRuleSet();
            this.makeAttribute("agenda-group", "agroup");
            this.makeAttribute("agenda-group", "bgroup");
            this.makeRuleTable();
            this.makeRow(11, "C", "A", "P");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "x");
            this.makeRow(15, "1", "show()", "10");
            this.listener.finishSheet();
            Package p = this.listener.getRuleSet();
            DRLOutput dout = new DRLOutput();
            p.renderDRL(dout);
            String drl = dout.getDRL();
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains("C3, C4"));
        }
    }

    @Test
    public void testPackageAttributeRendering() {
        this.makeRuleSet();
        this.makeAttribute("NO-LOOP", "true");
        this.makeAttribute("agenda-group", "agroup");
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "P");
        this.makeRow(12, "foo:Foo", "foo");
        this.makeRow(13, "attr == $param", "x($param)");
        this.makeRow(15, "1", "1", "100");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assert.assertTrue((boolean)drl.contains("no-loop true"));
        Assert.assertTrue((boolean)drl.contains("agenda-group \"agroup\""));
    }

    @Test
    public void testMissingCodeSnippetAction() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "A");
            this.makeRow(12, "foo: Foo", "Bar()");
            this.makeRow(13, "attr == $param");
            this.makeRow(15, "1", "1");
            this.makeRow(16, "2", "2");
            this.listener.finishSheet();
            Package p = this.listener.getRuleSet();
            DRLOutput dout = new DRLOutput();
            p.renderDRL(dout);
            String drl = dout.getDRL();
            System.out.println(drl);
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)2);
            System.err.println(e.getMessage());
            Assert.assertTrue((boolean)e.getMessage().contains(badCell));
        }
    }

    @Test
    public void testMetadata() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "@", "@");
        this.makeRow(12, "foo: Foo", "foo");
        this.makeRow(13, "attr == $param", "goaway($param)", "Author($param)", "Version($1-$2)");
        this.makeRow(15, "1", "1", "J.W.Goethe", "3,14");
        this.makeRow(16, "2", "2", "", "");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assert.assertTrue((boolean)drl.contains("@Author(J.W.Goethe)"));
        Assert.assertTrue((boolean)drl.contains("@Version(3-14)"));
        Assert.assertFalse((boolean)drl.contains("@Author()"));
        Assert.assertFalse((boolean)drl.contains("@Version(-)"));
    }

    @Test
    public void testQuoteEscapingEnabled() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/QuoteEscapeEnabledWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assert.assertNotNull((Object)ruleset);
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assert.assertEquals((Object)"Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")", (Object)cond.getSnippet());
    }

    @Test
    public void testQuoteEscapingDisabled() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/QuoteEscapeDisabledWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assert.assertNotNull((Object)ruleset);
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assert.assertEquals((Object)"Foo(myObject.getColour().equals(red), myObject.size () > \"12\")", (Object)cond.getSnippet());
        rule = (Rule)ruleset.getRules().get(1);
        cond = (Condition)rule.getConditions().get(0);
        Assert.assertEquals((Object)"Foo(myObject.getColour().equals(blue), myObject.size () > 12\")", (Object)cond.getSnippet());
    }

    @Test
    public void testSalienceRange() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/SalienceRangeWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assert.assertNotNull((Object)ruleset);
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        List rules = ruleset.getRules();
        Assert.assertEquals((Object)"10000", (Object)((Rule)rules.get(0)).getSalience());
        Assert.assertEquals((Object)"9999", (Object)((Rule)rules.get(1)).getSalience());
    }

    @Test
    public void testSalienceOutOfRange() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/SalienceOutOfRangeWorkbook.xls");
        try {
            RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
            Assert.fail((String)"should have failed");
        }
        catch (DecisionTableParseException decisionTableParseException) {
            // empty catch block
        }
    }

    @Test
    public void testComplexWorksheetMissingConditionsInLocaleEnUs() throws Exception {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        this.doComplexWorksheetMissingConditions();
        Locale.setDefault(originalDefaultLocale);
    }

    @Test
    @Ignore
    public void testComplexWorksheetMissingConditionsInLocaleFrFr() throws Exception {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.FRANCE);
        this.doComplexWorksheetMissingConditions();
        Locale.setDefault(originalDefaultLocale);
    }

    private void doComplexWorksheetMissingConditions() throws IOException {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/ComplexWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assert.assertEquals((long)6L, (long)ruleset.getRules().size());
        Assert.assertEquals((long)0L, (long)ruleset.getImports().size());
        Rule rule = (Rule)ruleset.getRules().get(0);
        Assert.assertEquals((long)3L, (long)rule.getConditions().size());
        Assert.assertEquals((long)2L, (long)rule.getConsequences().size());
        Consequence cons = (Consequence)rule.getConsequences().get(1);
        Assert.assertEquals((Object)"myObject.setIsValid(1, 2)", (Object)cons.getSnippet());
        Condition con = (Condition)rule.getConditions().get(2);
        Assert.assertEquals((Object)"myObject.size() < $3.00", (Object)con.getSnippet());
        rule = (Rule)ruleset.getRules().get(4);
        Assert.assertEquals((long)1L, (long)rule.getConditions().size());
        rule = (Rule)ruleset.getRules().get(5);
        Assert.assertEquals((long)2L, (long)rule.getConditions().size());
        Assert.assertEquals((long)1L, (long)rule.getConsequences().size());
    }

    @Test
    public void testNumericDisabled() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/NumericDisabled.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assert.assertNotNull((Object)ruleset);
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assert.assertEquals((Object)"Cheese(price == 6600)", (Object)cond.getSnippet());
    }

    public static RuleSheetListener getRuleSheetListener(InputStream stream) throws IOException {
        return RulesheetUtil.getRuleSheetListener(stream);
    }
}

