/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import com.sample.FactData;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.decisiontable.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class LineBreakXLSTest {
    @Test
    public void makeSureAdditionalCodeLineEndsAreNotAdded() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLSX);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"testrule.xlsx", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        FactData fd = new FactData();
        fd.set\u5024(-1);
        ksession.insert((Object)fd);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertTrue((boolean)fd.get\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8().contains("\u5024\u306b\u306f0\u4ee5\u4e0a\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u6307\u5b9a\u3055\u308c\u305f\u5024\uff1a"));
    }

    @Test
    public void testMultipleLinesInAction() {
        DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dtconf.setInputType(DecisionTableInputType.XLS);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"MultiLinesInAction.xls", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        Person john = new Person("John");
        john.setAge(20);
        john.setAlive(true);
        ksession.insert((Object)john);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)30L, (long)john.getAge());
        Assert.assertFalse((boolean)john.isAlive());
    }
}

