/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Column;
import org.drools.template.parser.ColumnFactory;
import org.drools.template.parser.LongColumn;
import org.drools.template.parser.StringColumn;
import org.junit.Assert;
import org.junit.Test;

public class ColumnFactoryTest {
    @Test
    public void testGetColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column");
        Assert.assertTrue((boolean)(column instanceof StringColumn));
        Assert.assertEquals((Object)"column", (Object)column.getName());
    }

    @Test
    public void testGetStringArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: String[]");
        Assert.assertTrue((boolean)(column instanceof ArrayColumn));
        Assert.assertEquals((Object)"column", (Object)column.getName());
        Assert.assertEquals((Object)"StringCell", (Object)((ArrayColumn)column).getCellType());
    }

    @Test
    public void testGetLongArrayColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: Long[]");
        Assert.assertTrue((boolean)(column instanceof ArrayColumn));
        Assert.assertEquals((Object)"column", (Object)column.getName());
        Assert.assertEquals((Object)"LongCell", (Object)((ArrayColumn)column).getCellType());
    }

    @Test
    public void testGetArrayColumnSimple() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column[]");
        Assert.assertTrue((boolean)(column instanceof ArrayColumn));
        Assert.assertEquals((Object)"column", (Object)column.getName());
        Assert.assertEquals((Object)"StringCell", (Object)((ArrayColumn)column).getCellType());
    }

    @Test
    public void testGetLongColumn() {
        ColumnFactory f = new ColumnFactory();
        Column column = f.getColumn("column: Long");
        Assert.assertTrue((boolean)(column instanceof LongColumn));
        Assert.assertEquals((Object)"column", (Object)column.getName());
    }

    @Test
    public void testInvalidGetColumn() {
        try {
            ColumnFactory f = new ColumnFactory();
            f.getColumn("column$");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

