/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.Person;
import org.drools.template.parser.TemplateDataListener;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ExternalSpreadsheetCompilerTest {
    @Test
    public void testLoadFromClassPath() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", "/templates/test_template1.drl", 11, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("rule \"How cool is Shaun 12\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rule \"How cool is Kumar 11\"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.User;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import example.model.Car;") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadSpecificWorksheet() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/MultiSheetDST.xls", "Another Sheet", "/templates/test_template1.drl", 11, 2);
        Assert.assertNotNull((Object)drl);
    }

    @Test
    public void testLoadCsv() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/ComplexWorkbook.csv", "/templates/test_template2.drl", InputType.CSV, 10, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("myObject.setIsValid(1, 2)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.size () > 2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red),\n        myObject.size () > 1") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithMergedCells() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/BasicWorkbook.xls", "/templates/test_template3.drl", InputType.XLS, 10, 2);
        String drl1 = converter.compile("/data/BasicWorkbook.xls", "/templates/test_template3.drl", InputType.XLS, 21, 2);
        Assert.assertNotNull((Object)drl);
        Pattern p = Pattern.compile(".*setIsValid\\(Y\\).*setIsValid\\(Y\\).*setIsValid\\(Y\\).*", 40);
        Matcher m = p.matcher(drl);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("myObject.setIsValid(10-Jul-1974)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(colors.get(\"red\")), myObject.size() > 12\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0);
    }

    @Test
    public void testLoadBasicWithExtraCells() {
        ExternalSpreadsheetCompiler compiler = new ExternalSpreadsheetCompiler();
        String drl = compiler.compile("/data/BasicWorkbook.xls", "/templates/test_template4.drl", InputType.XLS, 10, 2);
        Assert.assertNotNull((Object)drl);
        Assert.assertTrue((drl.indexOf("This is a function block") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("global Class1 obj1;") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("myObject.getColour().equals(blue)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(colors.get(\"red\")), myObject.size() > 12\")") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("b: Bar()\n        eval(myObject.size() < 9)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("Foo(myObject.getColour().equals(red), myObject.size() > 1)") < drl.indexOf("b: Bar()\n        eval(myObject.size() < 3)") ? 1 : 0) != 0);
    }

    @Test
    public void testIntegration() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile("/data/IntegrationExampleTest.xls", "/templates/test_integration.drl", 18, 3);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = kbase.newKieSession();
        kSession.insert((Object)new Cheese("stilton", 42));
        kSession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testPricing() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        ArrayList<TemplateDataListener> listeners = new ArrayList<TemplateDataListener>();
        TemplateDataListener l1 = new TemplateDataListener(10, 3, "/templates/test_pricing1.drl");
        listeners.add(l1);
        TemplateDataListener l2 = new TemplateDataListener(30, 3, "/templates/test_pricing2.drl");
        listeners.add(l2);
        converter.compile("/data/ExamplePolicyPricing.xls", InputType.XLS, listeners);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])l1.renderDRL().getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])l2.renderDRL().getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession kSession = kbase.newKieSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        kSession.insert((Object)driver);
        kSession.insert((Object)policy);
        kSession.fireAllRules();
        System.out.println("BASE PRICE IS: " + policy.getBasePrice());
        System.out.println("DISCOUNT IS: " + policy.getDiscountPercent());
        int basePrice = policy.getBasePrice();
        Assert.assertEquals((long)120L, (long)basePrice);
    }
}

