/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.decisiontable.Cheese;
import org.drools.decisiontable.Person;
import org.junit.Test;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ChangeSetTest {
    @Test
    public void testIntegration() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        Assertions.assertThat(list.get(0)).isEqualTo((Object)"Young man cheddar");
        Assertions.assertThat(list.get(1)).isEqualTo((Object)"rule1");
        Assertions.assertThat(list.get(2)).isEqualTo((Object)"rule2");
    }

    @Test
    public void multipleSheets() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"multipleSheetsChangeSet.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar", 42));
        ksession.insert((Object)new Person("michael", "stilton", 25));
        ksession.insert((Object)new Person("Jane", "stilton", 55));
        ksession.fireAllRules();
        ksession.dispose();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        Assertions.assertThat((boolean)list.contains("Young man cheddar")).isTrue();
        Assertions.assertThat((boolean)list.contains("Jane eats cheddar")).isTrue();
    }

    @Test
    public void testCSV() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeSetTestCSV.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assertions.assertThat((boolean)kbuilder.hasErrors()).isFalse();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        Assertions.assertThat((int)kbase.getKiePackages().size()).isEqualTo(1);
        Assertions.assertThat((int)((KiePackage)kbase.getKiePackages().iterator().next()).getRules().size()).isEqualTo(3);
    }
}

