/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.drools.compiler.compiler.DecisionTableFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.junit.Test;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class ColumnReplaceTest {
    @Test
    public void testAutoFocusToLockOnActiveReplacement() throws FileNotFoundException {
        DecisionTableConfiguration dTableConfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
        dTableConfiguration.setInputType(DecisionTableInputType.CSV);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"columnReplaceTest.csv", this.getClass()), ResourceType.DTABLE, (ResourceConfiguration)dTableConfiguration);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assertions.fail((String)"Knowledge builder cannot compile package!");
        }
        System.out.println(DecisionTableFactory.loadFromInputStream((InputStream)new FileInputStream(new File("src/test/resources/org/drools/decisiontable/columnReplaceTest.csv")), (DecisionTableConfiguration)dTableConfiguration));
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        Assertions.assertThat((boolean)((RuleImpl)kbase.getRule("org.drools.decisiontable", "lockOnActiveRule")).isLockOnActive()).isTrue();
        Assertions.assertThat((boolean)((RuleImpl)kbase.getRule("org.drools.decisiontable", "autoFocusRule")).isLockOnActive()).isFalse();
        Assertions.assertThat((boolean)((RuleImpl)kbase.getRule("org.drools.decisiontable", "lockOnActiveRule")).getAutoFocus()).isFalse();
        Assertions.assertThat((boolean)((RuleImpl)kbase.getRule("org.drools.decisiontable", "autoFocusRule")).getAutoFocus()).isTrue();
    }
}

