/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.RulesheetUtil;
import org.drools.decisiontable.parser.xls.PropertiesSheetListener;
import org.drools.template.model.Condition;
import org.drools.template.model.Consequence;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Import;
import org.drools.template.model.Package;
import org.drools.template.model.Rule;
import org.drools.template.parser.DecisionTableParseException;
import org.junit.Ignore;
import org.junit.Test;

public class RuleWorksheetParseTest {
    private RuleSheetListener listener;
    private int row;

    @Test
    public void testBasicWorkbookProperties() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/BasicWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        PropertiesSheetListener.CaseInsensitiveMap props = listener.getProperties();
        Assertions.assertThat((Map)props).isNotNull();
        Assertions.assertThat((String)props.getSingleProperty("RuleSet")).isEqualTo("data");
        Assertions.assertThat((String)props.getSingleProperty("misc")).isEqualTo("someMisc");
    }

    @Test
    public void testComplexWorkbookProperties() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/ComplexWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        PropertiesSheetListener.CaseInsensitiveMap props = listener.getProperties();
        Assertions.assertThat((Map)props).isNotNull();
        String ruleSetName = props.getSingleProperty("RuleSet");
        Assertions.assertThat((String)ruleSetName).isEqualTo("data");
    }

    @Test
    public void testWorkbookParse() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/BasicWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assertions.assertThat((Object)ruleset).isNotNull();
        Rule firstRule = (Rule)ruleset.getRules().get(0);
        Assertions.assertThat((String)firstRule.getSalience()).isNotNull();
        Assertions.assertThat((Integer.parseInt(firstRule.getSalience()) > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)ruleset.getName()).isEqualTo("data");
        Assertions.assertThat((int)ruleset.getImports().size()).isEqualTo(3);
        Assertions.assertThat((int)ruleset.getRules().size()).isEqualTo(6);
        Import imp = (Import)ruleset.getImports().get(0);
        Assertions.assertThat((String)imp.getClassName()).isEqualTo("blah.class1");
        imp = (Import)ruleset.getImports().get(1);
        Assertions.assertThat((String)imp.getClassName()).isEqualTo("blah.class2");
        imp = (Import)ruleset.getImports().get(2);
        Assertions.assertThat((String)imp.getClassName()).isEqualTo("lah.di.dah");
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(colors.get(\"red\")), myObject.size () > 12\\\")");
        Consequence cons = (Consequence)rule.getConsequences().get(0);
        Assertions.assertThat((Object)cons).isNotNull();
        Assertions.assertThat((String)cons.getSnippet()).isEqualTo("myObject.setIsValid(Y);");
        rule = (Rule)ruleset.getRules().get(5);
        cond = (Condition)rule.getConditions().get(1);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("myObject.size () > 7");
        cons = (Consequence)rule.getConsequences().get(0);
        Assertions.assertThat((String)cons.getSnippet()).isEqualTo("myObject.setIsValid(10-Jul-1974)");
    }

    private void makeRuleSet() {
        this.listener = new DefaultRuleSheetListener();
        this.listener.startSheet("bad_sheet");
        this.row = 1;
        this.listener.newRow(this.row, 2);
        this.listener.newCell(this.row, 1, "RuleSet", -1);
        this.listener.newCell(this.row, 2, "myRuleSet", -1);
    }

    private void makeAttribute(String key, String val) {
        ++this.row;
        this.listener.newRow(this.row, 2);
        this.listener.newCell(this.row, 1, key, -1);
        this.listener.newCell(this.row, 2, val, -1);
    }

    private void makeRuleTable() {
        this.listener.newRow(10, 1);
        this.listener.newCell(10, 1, "RuleTable myRuleTable", -1);
    }

    private void makeRow(int row, String ... values) throws DecisionTableParseException {
        this.listener.newRow(row, values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            this.listener.newCell(row, i + 1, values[i], -1);
        }
    }

    @Test
    public void testTooManyColumnsNoLoop() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "A", "U", "U");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)11, (int)5);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testTooManyColumnsPriority() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "A", "PRIORITY", "P");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)11, (int)5);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testBadColumnHeader() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "Condition", "CONDITION", "A", "SMURF", "P");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)11, (int)4);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testMissingCondition() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "C", "A", "A");
            this.makeRow(12, "attr == $param", "attr == $param", "attr == $param", "action();", "action();");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)12, (int)1);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testSpuriousCodeSnippet() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "C", "A");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "attr == $param", "action();", "attr > $param");
            this.makeRow(15, "1", "2", "");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)4);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testIncorrectPriority() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "A", "P");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "x");
            this.makeRow(15, "1", "show()", "12E");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)15, (int)3);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testSnippetForAttribute() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "A", "G");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "x", "XXX");
            this.makeRow(15, "1", "show()", "10");
            this.listener.finishSheet();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)3);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testRuleAttributeRendering() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "G");
        this.makeRow(12, "Foo", "Foo");
        this.makeRow(13, "attr == $param", "x");
        this.makeRow(15, "1", "show()", "foo bar");
        this.makeRow(16, "2", "list()", "\"10\" group\"");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assertions.assertThat((boolean)drl.contains("agenda-group \"foo bar\"")).isTrue();
        Assertions.assertThat((boolean)drl.contains("agenda-group \"10\\\" group\"")).isTrue();
    }

    @Test
    public void testDuplicatePackageAttribute() {
        try {
            this.makeRuleSet();
            this.makeAttribute("agenda-group", "agroup");
            this.makeAttribute("agenda-group", "bgroup");
            this.makeRuleTable();
            this.makeRow(11, "C", "A", "P");
            this.makeRow(12, "Foo", "Foo");
            this.makeRow(13, "attr == $param", "x");
            this.makeRow(15, "1", "show()", "10");
            this.listener.finishSheet();
            Package p = this.listener.getRuleSet();
            DRLOutput dout = new DRLOutput();
            p.renderDRL(dout);
            String drl = dout.getDRL();
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains("C3, C4")).isTrue();
        }
    }

    @Test
    public void testPackageAttributeRendering() {
        this.makeRuleSet();
        this.makeAttribute("NO-LOOP", "true");
        this.makeAttribute("agenda-group", "agroup");
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "P");
        this.makeRow(12, "foo:Foo", "foo");
        this.makeRow(13, "attr == $param", "x($param)");
        this.makeRow(15, "1", "1", "100");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assertions.assertThat((boolean)drl.contains("no-loop true")).isTrue();
        Assertions.assertThat((boolean)drl.contains("agenda-group \"agroup\"")).isTrue();
    }

    @Test
    public void testMissingCodeSnippetAction() {
        try {
            this.makeRuleSet();
            this.makeRuleTable();
            this.makeRow(11, "C", "A");
            this.makeRow(12, "foo: Foo", "Bar()");
            this.makeRow(13, "attr == $param");
            this.makeRow(15, "1", "1");
            this.makeRow(16, "2", "2");
            this.listener.finishSheet();
            Package p = this.listener.getRuleSet();
            DRLOutput dout = new DRLOutput();
            p.renderDRL(dout);
            String drl = dout.getDRL();
            System.out.println(drl);
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException e) {
            String badCell = RuleSheetParserUtil.rc2name((int)13, (int)2);
            System.err.println(e.getMessage());
            Assertions.assertThat((boolean)e.getMessage().contains(badCell)).isTrue();
        }
    }

    @Test
    public void testMetadata() {
        this.makeRuleSet();
        this.makeRuleTable();
        this.makeRow(11, "C", "A", "@", "@");
        this.makeRow(12, "foo: Foo", "foo");
        this.makeRow(13, "attr == $param", "goaway($param)", "Author($param)", "Version($1-$2)");
        this.makeRow(15, "1", "1", "J.W.Goethe", "3,14");
        this.makeRow(16, "2", "2", "", "");
        this.listener.finishSheet();
        Package p = this.listener.getRuleSet();
        DRLOutput dout = new DRLOutput();
        p.renderDRL(dout);
        String drl = dout.getDRL();
        Assertions.assertThat((boolean)drl.contains("@Author(J.W.Goethe)")).isTrue();
        Assertions.assertThat((boolean)drl.contains("@Version(3-14)")).isTrue();
        Assertions.assertThat((boolean)drl.contains("@Author()")).isFalse();
        Assertions.assertThat((boolean)drl.contains("@Version(-)")).isFalse();
    }

    @Test
    public void testQuoteEscapingEnabled() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/QuoteEscapeEnabledWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assertions.assertThat((Object)ruleset).isNotNull();
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(red), myObject.size () > 12\\\")");
    }

    @Test
    public void testQuoteEscapingDisabled() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/QuoteEscapeDisabledWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assertions.assertThat((Object)ruleset).isNotNull();
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(red), myObject.size () > \"12\")");
        rule = (Rule)ruleset.getRules().get(1);
        cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Foo(myObject.getColour().equals(blue), myObject.size () > 12\")");
    }

    @Test
    public void testSalienceRange() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/SalienceRangeWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assertions.assertThat((Object)ruleset).isNotNull();
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        List rules = ruleset.getRules();
        Assertions.assertThat((String)((Rule)rules.get(0)).getSalience()).isEqualTo("10000");
        Assertions.assertThat((String)((Rule)rules.get(1)).getSalience()).isEqualTo("9999");
    }

    @Test
    public void testSalienceOutOfRange() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/SalienceOutOfRangeWorkbook.xls");
        try {
            RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
            Assertions.fail((String)"should have failed");
        }
        catch (DecisionTableParseException decisionTableParseException) {
            // empty catch block
        }
    }

    @Test
    public void testComplexWorksheetMissingConditionsInLocaleEnUs() throws Exception {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        this.doComplexWorksheetMissingConditions();
        Locale.setDefault(originalDefaultLocale);
    }

    @Test
    @Ignore
    public void testComplexWorksheetMissingConditionsInLocaleFrFr() throws Exception {
        Locale originalDefaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.FRANCE);
        this.doComplexWorksheetMissingConditions();
        Locale.setDefault(originalDefaultLocale);
    }

    private void doComplexWorksheetMissingConditions() throws IOException {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/ComplexWorkbook.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assertions.assertThat((int)ruleset.getRules().size()).isEqualTo(6);
        Assertions.assertThat((int)ruleset.getImports().size()).isEqualTo(0);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Assertions.assertThat((int)rule.getConditions().size()).isEqualTo(3);
        Assertions.assertThat((int)rule.getConsequences().size()).isEqualTo(2);
        Consequence cons = (Consequence)rule.getConsequences().get(1);
        Assertions.assertThat((String)cons.getSnippet()).isEqualTo("myObject.setIsValid(1, 2)");
        Condition con = (Condition)rule.getConditions().get(2);
        Assertions.assertThat((String)con.getSnippet()).isEqualTo("myObject.size() < $3.00");
        rule = (Rule)ruleset.getRules().get(4);
        Assertions.assertThat((int)rule.getConditions().size()).isEqualTo(1);
        rule = (Rule)ruleset.getRules().get(5);
        Assertions.assertThat((int)rule.getConditions().size()).isEqualTo(2);
        Assertions.assertThat((int)rule.getConsequences().size()).isEqualTo(1);
    }

    @Test
    public void testNumericDisabled() throws Exception {
        InputStream stream = RuleWorksheetParseTest.class.getResourceAsStream("/data/NumericDisabled.xls");
        RuleSheetListener listener = RuleWorksheetParseTest.getRuleSheetListener(stream);
        Package ruleset = listener.getRuleSet();
        Assertions.assertThat((Object)ruleset).isNotNull();
        DRLOutput dout = new DRLOutput();
        ruleset.renderDRL(dout);
        String drl = dout.getDRL();
        System.out.println(drl);
        Rule rule = (Rule)ruleset.getRules().get(0);
        Condition cond = (Condition)rule.getConditions().get(0);
        Assertions.assertThat((String)cond.getSnippet()).isEqualTo("Cheese(price == 6600)");
    }

    public static RuleSheetListener getRuleSheetListener(InputStream stream) throws IOException {
        return RulesheetUtil.getRuleSheetListener(stream);
    }
}

